/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.wsrp;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.gatein.wsrp.api.session.SessionEvent;
import org.gatein.wsrp.api.session.SessionEventBroadcaster;
import org.gatein.wsrp.api.session.SessionEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionEventListenerAndBroadcaster
extends Listener<PortalContainer, HttpSessionEvent>
implements SessionEventBroadcaster {
    private Map<String, SessionEventListener> listeners = new ConcurrentHashMap<String, SessionEventListener>();
    private static final String SESSION_CREATED = "org.exoplatform.web.GenericHttpListener.sessionCreated";
    private static final String SESSION_DESTROYED = "org.exoplatform.web.GenericHttpListener.sessionDestroyed";

    public void registerListener(String listenerId, SessionEventListener listener) {
        this.listeners.put(listenerId, listener);
    }

    public void unregisterListener(String listenerId) {
        this.listeners.remove(listenerId);
    }

    public void notifyListenersOf(SessionEvent event) {
        for (SessionEventListener listener : this.listeners.values()) {
            listener.onSessionEvent(event);
        }
    }

    public void onEvent(Event<PortalContainer, HttpSessionEvent> event) throws Exception {
        SessionEvent.SessionEventType eventType;
        String eventName = event.getEventName();
        if (SESSION_CREATED.equals(eventName)) {
            eventType = SessionEvent.SessionEventType.SESSION_CREATED;
        } else if (SESSION_DESTROYED.equals(eventName)) {
            eventType = SessionEvent.SessionEventType.SESSION_DESTROYED;
        } else {
            return;
        }
        this.notifyListenersOf(new SimpleSessionEvent(eventType, ((HttpSessionEvent)event.getData()).getSession()));
    }

    private static class SimpleSessionEvent
    implements SessionEvent {
        private SessionEvent.SessionEventType eventType;
        private HttpSession session;

        private SimpleSessionEvent(SessionEvent.SessionEventType eventType, HttpSession session) {
            this.eventType = eventType;
            this.session = session;
        }

        public SessionEvent.SessionEventType getType() {
            return this.eventType;
        }

        public HttpSession getSession() {
            return this.session;
        }
    }
}

