/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.cli.crash.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import org.crsh.plugin.WebPluginLifeCycle;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class CustomWebPluginLifecycle
extends WebPluginLifeCycle {
    private static final Properties crashProperties = new Properties();
    private static final Logger log = LoggerFactory.getLogger(CustomWebPluginLifecycle.class);

    public static Properties getCrashProperties() {
        return crashProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        super.contextInitialized(sce);
        String path = "/WEB-INF/crash/crash.properties";
        InputStream in = sce.getServletContext().getResourceAsStream(path);
        try {
            crashProperties.load(in);
        }
        catch (IOException e) {
            log.error((Object)("Exception reading file " + path), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        super.contextDestroyed(sce);
        crashProperties.clear();
    }
}

