/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api.binding.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gatein.common.io.IOTools;
import org.gatein.management.api.binding.BindingException;
import org.gatein.management.api.binding.Marshaller;
import org.gatein.management.api.operation.model.ExportResourceModel;
import org.gatein.management.api.operation.model.ExportTask;

public class ExportResourceModelMarshaller
implements Marshaller<ExportResourceModel> {
    public void marshal(ExportResourceModel model, OutputStream outputStream) throws BindingException {
        File file;
        ZipOutputStream zos = null;
        try {
            file = File.createTempFile("gatein-export", ".zip");
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (IOException e) {
            throw new BindingException("Could not create temp file for export.", (Throwable)e);
        }
        try {
            if (model.getTasks().isEmpty()) {
                zos.putNextEntry(new ZipEntry(""));
            } else {
                for (ExportTask task : model.getTasks()) {
                    String entry = task.getEntry();
                    zos.putNextEntry(new ZipEntry(entry));
                    task.export((OutputStream)zos);
                    zos.closeEntry();
                }
            }
            zos.flush();
            zos.finish();
        }
        catch (Throwable t) {
            throw new BindingException("Exception writing data to zip.", t);
        }
        finally {
            IOTools.safeClose((Closeable)zos);
        }
        try {
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            IOTools.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (FileNotFoundException e) {
            throw new BindingException("Could not read from temporary zip file " + file, (Throwable)e);
        }
        catch (IOException e) {
            throw new BindingException("IOException writing data to final output stream.", (Throwable)e);
        }
    }

    public ExportResourceModel unmarshal(InputStream inputStream) throws BindingException {
        throw new UnsupportedOperationException();
    }
}

