/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.ManagedDescription;
import org.gatein.management.api.ManagedResource;
import org.gatein.management.api.ManagementService;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.binding.BindingException;
import org.gatein.management.api.binding.BindingProvider;
import org.gatein.management.api.binding.Marshaller;
import org.gatein.management.api.operation.OperationHandler;
import org.gatein.management.core.api.SimpleManagedResource;
import org.gatein.management.core.api.binding.GlobalBindingProvider;
import org.gatein.management.core.api.operation.global.GlobalOperationHandlers;
import org.gatein.management.core.spi.ExtensionContextImpl;
import org.gatein.management.spi.ExtensionContext;
import org.gatein.management.spi.ManagementExtension;

public class ManagementServiceImpl
implements ManagementService {
    private static final Logger log = LoggerFactory.getLogger(ManagementService.class);
    private ManagedResource rootResource;
    private List<ManagementExtension> extensions;
    private Map<String, BindingProvider> bindingProviders;
    private BindingProvider globalBindingProvider;

    public ManagedResource getManagedResource(PathAddress address) {
        return this.rootResource.getSubResource(address);
    }

    public BindingProvider getBindingProvider(final String componentName) {
        return new BindingProvider(){

            public <T> Marshaller<T> getMarshaller(Class<T> type, ContentType contentType) throws BindingException {
                Marshaller marshaller = null;
                BindingProvider bp = (BindingProvider)ManagementServiceImpl.this.bindingProviders.get(componentName);
                if (bp != null) {
                    marshaller = bp.getMarshaller(type, contentType);
                }
                if (marshaller == null) {
                    marshaller = ManagementServiceImpl.this.globalBindingProvider.getMarshaller(type, contentType);
                }
                return marshaller;
            }
        };
    }

    public void reloadExtensions() {
        this.unload();
        this.load();
    }

    public void load() {
        this.extensions = new ArrayList<ManagementExtension>();
        SimpleManagedResource resource = new SimpleManagedResource(null, null, new ManagedDescription(){

            public String getDescription() {
                return "Root management resource.";
            }
        });
        HashMap<String, BindingProvider> map = new HashMap<String, BindingProvider>();
        ExtensionContextImpl context = new ExtensionContextImpl(resource, map);
        ServiceLoader<ManagementExtension> loader = ServiceLoader.load(ManagementExtension.class);
        for (ManagementExtension extension : loader) {
            extension.initialize((ExtensionContext)context);
            this.extensions.add(extension);
        }
        log.debug((Object)("Successfully loaded " + this.extensions.size() + " management extension(s)."));
        this.initGlobalOperations(resource);
        this.rootResource = resource;
        this.bindingProviders = map;
        this.globalBindingProvider = new GlobalBindingProvider();
    }

    public void unload() {
        if (this.extensions != null) {
            for (ManagementExtension extension : this.extensions) {
                extension.destroy();
            }
            this.extensions.clear();
        }
        this.rootResource = null;
    }

    private void initGlobalOperations(ManagedResource.Registration registration) {
        registration.registerOperationHandler("read-resource", (OperationHandler)GlobalOperationHandlers.READ_RESOURCE, (ManagedDescription)GlobalOperationHandlers.READ_RESOURCE, true);
    }
}

