/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.rest;

import java.io.InputStream;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.controller.ManagedRequest;
import org.gatein.management.api.controller.ManagedResponse;
import org.gatein.management.api.controller.ManagementController;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.operation.model.NoResultModel;
import org.gatein.management.api.operation.model.ReadResourceModel;
import org.gatein.management.rest.ContentTypeUtils;
import org.gatein.management.rest.FailureResult;
import org.gatein.management.rest.HttpManagedRequest;
import org.gatein.management.rest.HttpManagedRequestBuilder;
import org.gatein.management.rest.content.Resource;

@Path(value="/managed-components")
public class RestController {
    private static final Logger log = LoggerFactory.getLogger(RestController.class);
    private ManagementController controller;

    public RestController(ManagementController controller) {
        this.controller = controller;
    }

    @GET
    @Produces(value={"text/html", "application/json", "application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response htmlGetRequest(@Context UriInfo uriInfo) {
        return this.htmlGetRequest(uriInfo, "");
    }

    @GET
    @Path(value="/{path:.*}")
    @Produces(value={"text/html", "application/json", "application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response htmlGetRequest(@Context UriInfo uriInfo, @PathParam(value="path") String path) {
        HttpManagedRequest request = HttpManagedRequestBuilder.get().parameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).path(path).build();
        return this.executeRequest(uriInfo, request);
    }

    @POST
    @Consumes(value={"text/html"})
    @Produces(value={"text/html", "application/json", "application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response htmlPostRequest(@Context UriInfo uriInfo, InputStream data) {
        return this.htmlPostRequest(uriInfo, "", data);
    }

    @POST
    @Path(value="/{path:.*}")
    @Consumes(value={"text/html"})
    @Produces(value={"text/html", "application/json", "application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response htmlPostRequest(@Context UriInfo uriInfo, @PathParam(value="path") String path, InputStream data) {
        HttpManagedRequest request = HttpManagedRequestBuilder.post(data).parameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).path(path).build();
        return this.executeRequest(uriInfo, request);
    }

    @PUT
    @Consumes(value={"text/html"})
    @Produces(value={"text/html", "application/json", "application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response htmlPutRequest(@Context UriInfo uriInfo, InputStream data) {
        return this.htmlPutRequest(uriInfo, "", data);
    }

    @PUT
    @Path(value="/{path:.*}")
    @Consumes(value={"text/html"})
    @Produces(value={"text/html", "application/json", "application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response htmlPutRequest(@Context UriInfo uriInfo, @PathParam(value="path") String path, InputStream data) {
        HttpManagedRequest request = HttpManagedRequestBuilder.put(data).parameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).path(path).build();
        return this.executeRequest(uriInfo, request);
    }

    @DELETE
    @Produces(value={"text/html", "application/json", "application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response htmlDeleteRequest(@Context UriInfo uriInfo) {
        return this.htmlDeleteRequest(uriInfo, "");
    }

    @DELETE
    @Path(value="/{path:.*}")
    @Produces(value={"text/html", "application/json", "application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response htmlDeleteRequest(@Context UriInfo uriInfo, @PathParam(value="path") String path) {
        HttpManagedRequest request = HttpManagedRequestBuilder.delete().parameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).path(path).build();
        return this.executeRequest(uriInfo, request);
    }

    @GET
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response xmlGetRequest(@Context UriInfo uriInfo) {
        return this.xmlGetRequest(uriInfo, "");
    }

    @GET
    @Path(value="/{path:.*}")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response xmlGetRequest(@Context UriInfo uriInfo, @PathParam(value="path") String path) {
        HttpManagedRequest request = HttpManagedRequestBuilder.get().path(path).parameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).contentType(ContentType.XML).build();
        return this.executeRequest(uriInfo, request);
    }

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response xmlPostRequest(@Context UriInfo uriInfo, InputStream data) {
        return this.xmlPostRequest(uriInfo, "", data);
    }

    @POST
    @Path(value="/{path:.*}")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response xmlPostRequest(@Context UriInfo uriInfo, @PathParam(value="path") String path, InputStream data) {
        HttpManagedRequest request = HttpManagedRequestBuilder.post(data).parameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).path(path).contentType(ContentType.XML).build();
        return this.executeRequest(uriInfo, request);
    }

    @PUT
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response xmlPutRequest(@Context UriInfo uriInfo, InputStream data) {
        return this.xmlPutRequest(uriInfo, "", data);
    }

    @PUT
    @Path(value="/{path:.*}")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response xmlPutRequest(@Context UriInfo uriInfo, @PathParam(value="path") String path, InputStream data) {
        HttpManagedRequest request = HttpManagedRequestBuilder.put(data).parameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).path(path).contentType(ContentType.XML).build();
        return this.executeRequest(uriInfo, request);
    }

    @DELETE
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response xmlDeleteRequest(@Context UriInfo uriInfo) {
        return this.xmlDeleteRequest(uriInfo, "");
    }

    @DELETE
    @Path(value="/{path:.*}")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"administrators"})
    public Response xmlDeleteRequest(@Context UriInfo uriInfo, @PathParam(value="path") String path) {
        HttpManagedRequest request = HttpManagedRequestBuilder.delete().parameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).path(path).contentType(ContentType.XML).build();
        return this.executeRequest(uriInfo, request);
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response jsonGetRequest(@Context UriInfo uriInfo) {
        return this.jsonGetRequest(uriInfo, "");
    }

    @GET
    @Path(value="/{path:.*}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response jsonGetRequest(@Context UriInfo uriInfo, @PathParam(value="path") String path) {
        HttpManagedRequest request = HttpManagedRequestBuilder.get().path(path).parameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).contentType(ContentType.JSON).build();
        return this.executeRequest(uriInfo, request);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response jsonPostRequest(@Context UriInfo uriInfo, InputStream data) {
        return this.jsonPostRequest(uriInfo, "", data);
    }

    @POST
    @Path(value="/{path:.*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response jsonPostRequest(@Context UriInfo uriInfo, @PathParam(value="path") String path, InputStream data) {
        HttpManagedRequest request = HttpManagedRequestBuilder.post(data).parameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).path(path).contentType(ContentType.JSON).build();
        return this.executeRequest(uriInfo, request);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response jsonPutRequest(@Context UriInfo uriInfo, InputStream data) {
        return this.jsonPutRequest(uriInfo, "", data);
    }

    @PUT
    @Path(value="/{path:.*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response jsonPutRequest(@Context UriInfo uriInfo, @PathParam(value="path") String path, InputStream data) {
        HttpManagedRequest request = HttpManagedRequestBuilder.put(data).parameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).path(path).contentType(ContentType.JSON).build();
        return this.executeRequest(uriInfo, request);
    }

    @DELETE
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response jsonDeleteRequest(@Context UriInfo uriInfo) {
        return this.jsonDeleteRequest(uriInfo, "");
    }

    @DELETE
    @Path(value="/{path:.*}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response jsonDeleteRequest(@Context UriInfo uriInfo, @PathParam(value="path") String path) {
        HttpManagedRequest request = HttpManagedRequestBuilder.delete().parameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).path(path).contentType(ContentType.JSON).build();
        return this.executeRequest(uriInfo, request);
    }

    @GET
    @Path(value="/{path:.*}")
    @Produces(value={"application/zip"})
    @RolesAllowed(value={"administrators"})
    public Response zipGetRequest(@Context UriInfo uriInfo, @PathParam(value="path") String path) {
        HttpManagedRequest request = HttpManagedRequestBuilder.get().path(path).parameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).operationName("export-resource").contentType(ContentType.ZIP).build();
        return this.executeRequest(uriInfo, request);
    }

    @PUT
    @Path(value="/{path:.*}")
    @Consumes(value={"application/zip"})
    @Produces(value={"application/xml", "application/json"})
    @RolesAllowed(value={"administrators"})
    public Response zipPutRequest(@Context UriInfo uriInfo, @PathParam(value="path") String path, InputStream data) {
        HttpManagedRequest request = HttpManagedRequestBuilder.put(data).path(path).parameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()).operationName("import-resource").contentType(ContentType.ZIP).build();
        return this.executeRequest(uriInfo, request);
    }

    private Response executeRequest(UriInfo uriInfo, HttpManagedRequest request) {
        ContentType contentType = request.getContentType();
        if (contentType == null) {
            return Response.notAcceptable((List)Variant.mediaTypes((MediaType[])ContentTypeUtils.mediaTypes()).build()).build();
        }
        Response response = this.validateRequest(request);
        if (response != null) {
            return response;
        }
        String operationName = request.getOperationName();
        PathAddress address = request.getAddress();
        try {
            ManagedResponse resp = this.controller.execute((ManagedRequest)request);
            if (resp == null) {
                return this.failure("No response returned.", operationName, Response.Status.INTERNAL_SERVER_ERROR, contentType);
            }
            return this.success(uriInfo, resp, contentType);
        }
        catch (ResourceNotFoundException nfe) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Resource not found for address " + address), (Throwable)nfe);
            }
            return this.failure(nfe.getMessage(), operationName, Response.Status.NOT_FOUND, contentType);
        }
        catch (OperationException e) {
            log.error((Object)("Operation exception for operation: " + operationName + ", address: " + address + ", content-type: " + contentType), (Throwable)e);
            return this.failure(e.getMessage(), operationName, Response.Status.INTERNAL_SERVER_ERROR, contentType);
        }
        catch (Exception e) {
            String message = "Error processing operation: " + operationName + ", address: " + address + ", content-type: " + contentType;
            log.error((Object)message, (Throwable)e);
            return this.failure(message, operationName, Response.Status.INTERNAL_SERVER_ERROR, contentType);
        }
    }

    private Response failure(String failureDescription, String operationName, Response.Status status, ContentType contentType) {
        if (contentType == null) {
            contentType = ContentType.JSON;
        } else if (contentType == ContentType.ZIP) {
            contentType = ContentType.JSON;
        }
        MediaType mediaType = ContentTypeUtils.getMediaType(contentType);
        return Response.status((Response.Status)status).entity((Object)new FailureResult(failureDescription, operationName)).type(mediaType).build();
    }

    private Response success(UriInfo uriInfo, ManagedResponse response, ContentType contentType) {
        MediaType mediaType = ContentTypeUtils.getMediaType(contentType);
        Object result = response.getResult();
        if (result instanceof ReadResourceModel) {
            result = new Resource(uriInfo, (ReadResourceModel)result);
        } else if (result instanceof NoResultModel) {
            return Response.ok().type(mediaType).build();
        }
        return Response.ok((Object)result).type(mediaType).build();
    }

    private Response validateRequest(HttpManagedRequest request) {
        String operationName = request.getOperationName();
        String httpMethod = request.getHttpMethod();
        MediaType mediaType = ContentTypeUtils.getMediaType(request.getContentType());
        if (operationName.equals("read-resource")) {
            if (!httpMethod.equals("GET")) {
                return this.badRequest("Request must be a GET.", operationName, mediaType);
            }
        } else if (operationName.equals("add-resource")) {
            if (!httpMethod.equals("POST")) {
                return this.badRequest("Request must be a POST.", operationName, mediaType);
            }
        } else if (operationName.equals("update-resource")) {
            if (!httpMethod.equals("PUT")) {
                return this.badRequest("Request must be a POST.", operationName, mediaType);
            }
        } else if (operationName.equals("remove-resource") && !httpMethod.equals("DELETE")) {
            return this.badRequest("Request must be a DELETE.", operationName, mediaType);
        }
        return null;
    }

    private Response badRequest(String reason, String operationName, MediaType mediaType) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new FailureResult(reason, operationName)).type(mediaType).build();
    }
}

