/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.embed;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.Portlet;
import junit.framework.AssertionFailedError;
import org.gatein.pc.embed.EmbedServlet;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public abstract class AbstractTestCase {
    public static final String PORTLET_APP_PROLOG = "<portlet-app xmlns=\"http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd\"\nversion=\"2.0\">\n";
    public static final String PORTLET_APP_EPILOG = "</portlet-app>\n";

    public static WebArchive deployment(Class<? extends Portlet> ... portlets) {
        StringBuilder descriptor = new StringBuilder();
        descriptor.append(PORTLET_APP_PROLOG);
        for (Class<? extends Portlet> portlet : portlets) {
            descriptor.append("<portlet>\n");
            descriptor.append("<portlet-name>").append(portlet.getSimpleName()).append("</portlet-name>\n");
            descriptor.append("<portlet-class>").append(portlet.getName()).append("</portlet-class>\n");
            descriptor.append("<portlet-info>\n");
            descriptor.append("<title>").append(portlet.getSimpleName()).append("</title>\n");
            descriptor.append("</portlet-info>\n");
            descriptor.append("</portlet>\n");
        }
        descriptor.append(PORTLET_APP_EPILOG);
        return AbstractTestCase.deployment(descriptor.toString());
    }

    public static WebArchive deployment(String descriptor) {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class);
        war.setWebXML((Asset)new ByteArrayAsset(("<web-app\nxmlns=\"http://java.sun.com/xml/ns/javaee\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd\"\nversion=\"3.0\"><servlet>\n<servlet-name>EmbedServlet</servlet-name>\n<servlet-class>" + EmbedServlet.class.getName() + "</servlet-class>\n" + "<load-on-startup>0</load-on-startup>\n" + "</servlet>\n" + "<servlet-mapping>\n" + "<servlet-name>EmbedServlet</servlet-name>\n" + "<url-pattern>/embed/*</url-pattern>\n" + "</servlet-mapping>\n" + "</web-app>\n").getBytes()));
        war.addAsWebInfResource((Asset)new ByteArrayAsset(descriptor.getBytes()), "portlet.xml");
        return war;
    }

    public static Map<String, String> responseHeaders(HttpURLConnection conn) {
        Map<String, String> headers = Collections.emptyMap();
        int i = 0;
        while (true) {
            String name = conn.getHeaderFieldKey(i);
            String value = conn.getHeaderField(i);
            if (name == null && value == null) break;
            if (name != null) {
                if (headers.isEmpty()) {
                    headers = new HashMap<String, String>();
                }
                headers.put(name, value);
            }
            ++i;
        }
        return headers;
    }

    protected URL renderURL(URL deploymentURL, Class<? extends Portlet> portlet) {
        return this.renderURL(deploymentURL, Collections.singletonList(portlet));
    }

    protected URL renderURL(URL deploymentURL, Class<? extends Portlet> portlet1, Class<? extends Portlet> portlet2) {
        ArrayList<Class<? extends Portlet>> portlets = new ArrayList<Class<? extends Portlet>>();
        portlets.add(portlet1);
        portlets.add(portlet2);
        return this.renderURL(deploymentURL, portlets);
    }

    protected URL renderURL(URL deploymentURL, Iterable<Class<? extends Portlet>> portlets) {
        StringBuilder path = new StringBuilder("embed");
        for (Class<? extends Portlet> portlet : portlets) {
            path.append("/").append(portlet.getSimpleName());
        }
        try {
            return deploymentURL.toURI().resolve(path.toString()).toURL();
        }
        catch (Exception e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }
}

