/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.embed.resourceheader;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import junit.framework.Assert;
import org.gatein.pc.embed.AbstractTestCase;
import org.gatein.pc.embed.resourceheader.ResourceHeaderPortlet;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ResourceHeaderTestCase
extends AbstractTestCase {
    @Drone
    WebDriver driver;

    @Deployment
    public static WebArchive deployment() {
        return ResourceHeaderTestCase.deployment(ResourceHeaderPortlet.class);
    }

    @Test
    @RunAsClient
    public void testInteraction(@ArquillianResource URL deploymentURL) throws Exception {
        URL url = this.renderURL(deploymentURL, ResourceHeaderPortlet.class);
        this.driver.get(url.toString());
        WebElement link = this.driver.findElement(By.id((String)"url"));
        url = new URL(link.getAttribute("href"));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(false);
        conn.connect();
        Assert.assertEquals((int)500, (int)conn.getResponseCode());
        Map<String, String> headers = ResourceHeaderTestCase.responseHeaders(conn);
        Assert.assertTrue((boolean)headers.containsKey("foo"));
        Assert.assertEquals((String)"bar", (String)headers.get("foo"));
    }
}

