/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gatein.pc.api.InvalidPortletIdException;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.PortletStatus;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.state.DestroyCloneFailure;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.state.SimplePropertyMap;
import org.gatein.pc.portlet.support.PortletSupport;
import org.gatein.pc.portlet.support.info.PortletInfoSupport;

public class PortletInvokerSupport
implements PortletInvoker {
    public static final String FOO_PORTLET_ID = "/webapp1.foo";
    public static final String BAR_PORTLET_ID = "/webapp2.bar";
    private Map<String, PortletSupport> portlets = new HashMap<String, PortletSupport>();

    public void setValid(String portletId, boolean valid) {
        this.getPortlet((String)portletId).valid = valid;
    }

    public PortletSupport addPortlet(String portletId) {
        return this.addPortlet(portletId, new PortletInfoSupport());
    }

    public PortletSupport addPortlet(String portletId, PortletInfoSupport info) {
        if (portletId == null) {
            throw new IllegalArgumentException();
        }
        if (info == null) {
            throw new IllegalArgumentException();
        }
        PortletSupport portlet = new PortletSupport(portletId, info);
        if (this.portlets.put(portletId, portlet) != null) {
            throw new IllegalStateException();
        }
        return portlet;
    }

    public PortletInvokerSupport removePortlet(String portletId) {
        if (this.portlets.remove(portletId) == null) {
            throw new IllegalStateException();
        }
        return this;
    }

    public PortletSupport getPortlet(String portletId) throws IllegalArgumentException {
        if (portletId == null) {
            throw new IllegalArgumentException();
        }
        return this.portlets.get(portletId);
    }

    public Set<Portlet> getPortlets() {
        return new HashSet<Portlet>(this.portlets.values());
    }

    public Portlet getPortlet(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        return this.internalGetPortlet(portletContext);
    }

    public PortletStatus getStatus(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        return this.portlets.containsKey(portletContext.getId()) ? PortletStatus.OFFERED : null;
    }

    public PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
        PortletContext portletContext = invocation.getTarget();
        PortletSupport portlet = this.internalGetPortlet(portletContext);
        return portlet.invoke(invocation);
    }

    private PortletSupport internalGetPortlet(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        if (portletContext == null) {
            throw new IllegalArgumentException();
        }
        String portletId = portletContext.getId();
        PortletSupport portlet = this.portlets.get(portletId);
        if (portlet == null) {
            throw new NoSuchPortletException(portletId);
        }
        if (!portlet.valid) {
            throw new InvalidPortletIdException(portletId);
        }
        return portlet;
    }

    public PropertyMap getProperties(PortletContext portletContext, Set<String> keys) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        PortletSupport internalPortlet = this.internalGetPortlet(portletContext);
        SimplePropertyMap props = new SimplePropertyMap();
        for (String key : keys) {
            List<String> value = internalPortlet.state.get(key);
            if (value == null) continue;
            props.put((Object)key, new ArrayList<String>(value));
        }
        return props;
    }

    public PropertyMap getProperties(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        PortletSupport internalPortlet = this.internalGetPortlet(portletContext);
        SimplePropertyMap props = new SimplePropertyMap();
        for (String key : internalPortlet.state.keySet()) {
            List<String> value = internalPortlet.state.get(key);
            if (value == null) continue;
            props.put((Object)key, new ArrayList<String>(value));
        }
        return props;
    }

    public PortletContext createClone(PortletStateType stateType, PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public List<DestroyCloneFailure> destroyClones(List<PortletContext> portletContexts) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public PortletContext setProperties(PortletContext portletContext, PropertyChange[] changes) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public PortletContext exportPortlet(PortletStateType stateType, PortletContext originalPortletContext) throws PortletInvokerException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public PortletContext importPortlet(PortletStateType stateType, PortletContext originalPortletContext) throws PortletInvokerException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public boolean isActive() {
        return true;
    }
}

