/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.container;

import junit.framework.TestCase;
import org.gatein.pc.portlet.container.ObjectSupport;
import org.gatein.pc.portlet.container.PortletApplicationContext;
import org.gatein.pc.portlet.container.PortletApplicationContextSupport;
import org.gatein.pc.portlet.container.PortletApplicationObjectSupport;
import org.gatein.pc.portlet.container.PortletContainerContext;
import org.gatein.pc.portlet.container.PortletContainerContextSupport;
import org.gatein.pc.portlet.container.PortletContainerObjectSupport;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.object.PortletApplicationObject;
import org.gatein.pc.portlet.container.object.PortletContainerObject;
import org.gatein.pc.portlet.impl.container.LifeCycle;
import org.gatein.pc.portlet.impl.container.PortletApplicationLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletContainerLifeCycle;

public class LifeCycleReentranceDetectionTestCase
extends TestCase {
    PortletApplicationLifeCycle applicationLF;
    PortletApplicationObjectSupport application;
    PortletContainerLifeCycle containerLF;
    PortletContainerObjectSupport container;
    IllegalStateException ise;

    protected void setUp() throws Exception {
        this.ise = null;
    }

    public void testApplicationReentersApplication1() {
        this.application = new PortletApplicationObjectSupport("application");
        this.applicationLF = new PortletApplicationLifeCycle((PortletApplicationContext)new PortletApplicationContextSupport(), (PortletApplicationObject)this.application);
        this.application.startCallback = new InvokeLifeCycleCallback((LifeCycle)this.applicationLF, true, false);
        this.applicationLF.create();
        this.applicationLF.managedStart();
        LifeCycleReentranceDetectionTestCase.assertNotNull((Object)this.ise);
        LifeCycleReentranceDetectionTestCase.assertEquals((Object)LifeCycleStatus.STARTED, (Object)this.applicationLF.getStatus());
    }

    public void testApplicationReentersApplication2() {
        this.application = new PortletApplicationObjectSupport("application");
        this.applicationLF = new PortletApplicationLifeCycle((PortletApplicationContext)new PortletApplicationContextSupport(), (PortletApplicationObject)this.application);
        this.application.startCallback = new InvokeLifeCycleCallback((LifeCycle)this.applicationLF, true, true);
        this.applicationLF.create();
        this.applicationLF.managedStart();
        LifeCycleReentranceDetectionTestCase.assertNotNull((Object)this.ise);
        LifeCycleReentranceDetectionTestCase.assertNotNull((Object)this.applicationLF.getFailure());
    }

    public void testContainerReentersContainer1() {
        this.application = new PortletApplicationObjectSupport("application");
        this.applicationLF = new PortletApplicationLifeCycle((PortletApplicationContext)new PortletApplicationContextSupport(), (PortletApplicationObject)this.application);
        this.container = new PortletContainerObjectSupport("container");
        this.containerLF = this.applicationLF.addPortletContainer((PortletContainerContext)new PortletContainerContextSupport(), (PortletContainerObject)this.container);
        this.container.startCallback = new InvokeLifeCycleCallback((LifeCycle)this.containerLF, true, false);
        this.applicationLF.create();
        this.applicationLF.managedStart();
        LifeCycleReentranceDetectionTestCase.assertNotNull((Object)this.ise);
        LifeCycleReentranceDetectionTestCase.assertEquals((Object)LifeCycleStatus.STARTED, (Object)this.applicationLF.getStatus());
        LifeCycleReentranceDetectionTestCase.assertEquals((Object)LifeCycleStatus.STARTED, (Object)this.containerLF.getStatus());
    }

    public void testContainerReentersContainer2() {
        this.application = new PortletApplicationObjectSupport("application");
        this.applicationLF = new PortletApplicationLifeCycle((PortletApplicationContext)new PortletApplicationContextSupport(), (PortletApplicationObject)this.application);
        this.container = new PortletContainerObjectSupport("container");
        this.containerLF = this.applicationLF.addPortletContainer((PortletContainerContext)new PortletContainerContextSupport(), (PortletContainerObject)this.container);
        this.container.startCallback = new InvokeLifeCycleCallback((LifeCycle)this.containerLF, true, true);
        this.applicationLF.create();
        this.applicationLF.managedStart();
        LifeCycleReentranceDetectionTestCase.assertNotNull((Object)this.ise);
        LifeCycleReentranceDetectionTestCase.assertEquals((Object)LifeCycleStatus.STARTED, (Object)this.applicationLF.getStatus());
        LifeCycleReentranceDetectionTestCase.assertNotNull((Object)this.containerLF.getStatus());
    }

    public void testContainerReentersApplication1() {
        this.application = new PortletApplicationObjectSupport("application");
        this.applicationLF = new PortletApplicationLifeCycle((PortletApplicationContext)new PortletApplicationContextSupport(), (PortletApplicationObject)this.application);
        this.container = new PortletContainerObjectSupport("container");
        this.containerLF = this.applicationLF.addPortletContainer((PortletContainerContext)new PortletContainerContextSupport(), (PortletContainerObject)this.container);
        this.container.startCallback = new InvokeLifeCycleCallback((LifeCycle)this.applicationLF, true, false);
        this.applicationLF.create();
        this.applicationLF.managedStart();
        LifeCycleReentranceDetectionTestCase.assertNotNull((Object)this.ise);
        LifeCycleReentranceDetectionTestCase.assertEquals((Object)LifeCycleStatus.STARTED, (Object)this.applicationLF.getStatus());
        LifeCycleReentranceDetectionTestCase.assertEquals((Object)LifeCycleStatus.STARTED, (Object)this.containerLF.getStatus());
    }

    public void testContainerReentersApplication2() {
        this.application = new PortletApplicationObjectSupport("application");
        this.applicationLF = new PortletApplicationLifeCycle((PortletApplicationContext)new PortletApplicationContextSupport(), (PortletApplicationObject)this.application);
        this.container = new PortletContainerObjectSupport("container");
        this.containerLF = this.applicationLF.addPortletContainer((PortletContainerContext)new PortletContainerContextSupport(), (PortletContainerObject)this.container);
        this.container.startCallback = new InvokeLifeCycleCallback((LifeCycle)this.applicationLF, true, true);
        this.applicationLF.create();
        this.applicationLF.managedStart();
        LifeCycleReentranceDetectionTestCase.assertNotNull((Object)this.ise);
        LifeCycleReentranceDetectionTestCase.assertEquals((Object)LifeCycleStatus.STARTED, (Object)this.applicationLF.getStatus());
        LifeCycleReentranceDetectionTestCase.assertNotNull((Object)this.containerLF.getStatus());
    }

    private class InvokeLifeCycleCallback
    implements ObjectSupport.Callback {
        private LifeCycle lifeCycle;
        private boolean invokeStart;
        private boolean rethrowISE;

        private InvokeLifeCycleCallback(LifeCycle lifeCycle, boolean invokeStart, boolean rethrowISE) {
            this.lifeCycle = lifeCycle;
            this.invokeStart = invokeStart;
            this.rethrowISE = rethrowISE;
        }

        @Override
        public void execute() {
            block4: {
                try {
                    if (this.invokeStart) {
                        this.lifeCycle.managedStart();
                    } else {
                        this.lifeCycle.managedDestroy();
                    }
                }
                catch (IllegalStateException e) {
                    LifeCycleReentranceDetectionTestCase.this.ise = e;
                    if (!this.rethrowISE) break block4;
                    throw e;
                }
            }
        }
    }
}

