/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168;

import java.util.Iterator;
import java.util.Map;
import org.gatein.common.util.ParameterMap;
import org.gatein.pc.api.ParametersStateString;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.info.NavigationInfo;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.portlet.impl.jsr168.ResourceRequestParameterMap;

public class PortletRequestParameterMap {
    protected static final ParameterMap.AccessMode COPY_MODE = ParameterMap.AccessMode.get((boolean)true, (boolean)true);
    protected final ParameterMap parameters;
    protected final ParameterMap privateParameters;
    protected final ParameterMap publicParameters;

    public static PortletRequestParameterMap create(NavigationInfo navigationInfo, PortletInvocation invocation) {
        if (invocation instanceof EventInvocation) {
            return PortletRequestParameterMap.create(navigationInfo, (EventInvocation)invocation);
        }
        if (invocation instanceof ActionInvocation) {
            return PortletRequestParameterMap.create(navigationInfo, (ActionInvocation)invocation);
        }
        if (invocation instanceof RenderInvocation) {
            return PortletRequestParameterMap.create(navigationInfo, (RenderInvocation)invocation);
        }
        return ResourceRequestParameterMap.create(navigationInfo, (ResourceInvocation)invocation);
    }

    public static PortletRequestParameterMap create(NavigationInfo navigationInfo, EventInvocation invocation) {
        ParameterMap publicParameters = PortletRequestParameterMap.safeBuildPublicParameters(navigationInfo, invocation.getPublicNavigationalState());
        Map<String, String[]> privateParameters = PortletRequestParameterMap.safeBuildParameters(invocation.getNavigationalState());
        Map<String, String[]> parameters = PortletRequestParameterMap.safeCombine(privateParameters, (Map<String, String[]>)publicParameters);
        return new PortletRequestParameterMap(parameters, privateParameters, (Map<String, String[]>)publicParameters);
    }

    public static PortletRequestParameterMap create(NavigationInfo navigationInfo, RenderInvocation context) {
        ParameterMap publicParameters = PortletRequestParameterMap.safeBuildPublicParameters(navigationInfo, context.getPublicNavigationalState());
        Map<String, String[]> privateParameters = PortletRequestParameterMap.safeBuildParameters(context.getNavigationalState());
        Map<String, String[]> parameters = PortletRequestParameterMap.safeCombine(privateParameters, (Map<String, String[]>)publicParameters);
        return new PortletRequestParameterMap(parameters, privateParameters, (Map<String, String[]>)publicParameters);
    }

    public static PortletRequestParameterMap create(NavigationInfo navigationInfo, ActionInvocation invocation) {
        ParameterMap publicParameters = PortletRequestParameterMap.safeBuildPublicParameters(navigationInfo, invocation.getPublicNavigationalState());
        Map<String, String[]> privateParameters = PortletRequestParameterMap.safeBuildParameters(invocation.getInteractionState());
        privateParameters = PortletRequestParameterMap.safeCombine(privateParameters, invocation.getForm());
        Map<String, String[]> parameters = PortletRequestParameterMap.safeCombine(privateParameters, (Map<String, String[]>)publicParameters);
        return new PortletRequestParameterMap(parameters, privateParameters, (Map<String, String[]>)publicParameters);
    }

    protected PortletRequestParameterMap(Map<String, String[]> parameters, Map<String, String[]> privateParameters, Map<String, String[]> publicParameters) {
        this.privateParameters = privateParameters != null ? ParameterMap.wrap(privateParameters, (ParameterMap.AccessMode)COPY_MODE) : null;
        this.publicParameters = publicParameters != null ? ParameterMap.wrap(publicParameters, (ParameterMap.AccessMode)COPY_MODE) : null;
        this.parameters = parameters != null ? ParameterMap.wrap(parameters, (ParameterMap.AccessMode)COPY_MODE) : null;
    }

    public ParameterMap getParameters() {
        return this.parameters;
    }

    public ParameterMap getPrivateParameters() {
        return this.privateParameters;
    }

    public ParameterMap getPublicParameters() {
        return this.publicParameters;
    }

    protected static ParameterMap safeBuildPublicParameters(NavigationInfo navigationInfo, Map<String, String[]> publicNavigationalParameters) {
        if (publicNavigationalParameters != null) {
            ParameterMap publicParameters = ParameterMap.clone(publicNavigationalParameters);
            Iterator i = publicParameters.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (navigationInfo.getPublicParameter(name) != null) continue;
                i.remove();
            }
            return publicParameters;
        }
        return null;
    }

    protected static Map<String, String[]> safeBuildParameters(StateString stateString) {
        if (stateString != null) {
            return ParametersStateString.create((StateString)stateString).getParameters();
        }
        return null;
    }

    protected static Map<String, String[]> safeCombine(Map<String, String[]> privateParameters, Map<String, String[]> publicParameters) {
        if (publicParameters != null) {
            if (privateParameters != null) {
                ParameterMap parameters = ParameterMap.clone(privateParameters);
                parameters.append(publicParameters);
                return parameters;
            }
            return publicParameters;
        }
        if (privateParameters != null) {
            return privateParameters;
        }
        return null;
    }
}

