/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.samples.basic;

import java.io.IOException;
import java.io.PrintWriter;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.common.text.EntityEncoder;

/*
 * Exception performing whole class analysis ignored.
 */
public class CharsetPortlet
extends GenericPortlet {
    public void processAction(ActionRequest req, ActionResponse resp) throws PortletException, PortletSecurityException, IOException {
        int to;
        int from;
        String fromString = req.getParameter("from");
        String toString = req.getParameter("to");
        try {
            from = Integer.parseInt(fromString);
            to = Integer.parseInt(toString);
        }
        catch (NumberFormatException ignore) {
            from = 65;
            to = 256;
        }
        resp.setRenderParameter("from", "" + from);
        resp.setRenderParameter("to", "" + to);
        String text = req.getParameter("text");
        if (text != null) {
            StringBuffer buffer = new StringBuffer();
            for (int i = from; i < to; ++i) {
                char c = (char)i;
                if (!CharsetPortlet.useChar((char)c)) continue;
                buffer.append(c);
            }
            String expectedText = buffer.toString();
            boolean same = expectedText.equals(text);
            if (!same) {
                this.getPortletContext().log("The input does not match the expected string");
                this.getPortletContext().log("Expected string " + expectedText);
                this.getPortletContext().log("Received string " + text);
            }
            resp.setRenderParameter("same", "" + same);
        }
    }

    protected void doHelp(RenderRequest req, RenderResponse resp) throws PortletException, PortletSecurityException, IOException {
        resp.setContentType("text/html");
        PrintWriter writer = resp.getWriter();
        writer.print("This portlet shows different ways to properly display and submit unicode text");
    }

    protected void doView(RenderRequest req, RenderResponse resp) throws PortletException, PortletSecurityException, IOException {
        String sameString = req.getParameter("same");
        Boolean same = null;
        if ("true".equalsIgnoreCase(sameString)) {
            same = Boolean.TRUE;
        } else if ("false".equalsIgnoreCase(sameString)) {
            same = Boolean.FALSE;
        }
        String fromString = req.getParameter("from");
        String toString = req.getParameter("to");
        int from = 65;
        int to = 256;
        try {
            from = Integer.parseInt(fromString);
            to = from + 16;
            to = Integer.parseInt(toString);
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        if (to <= from) {
            to = from + 16;
        }
        StringBuffer escapedText = new StringBuffer();
        StringBuffer text = new StringBuffer();
        for (int i = from; i < to; ++i) {
            char c = (char)i;
            if (!CharsetPortlet.useChar((char)c)) continue;
            text.append(c);
            String s = EntityEncoder.FULL.lookup(c);
            if (s == null) {
                escapedText.append(c);
                continue;
            }
            escapedText.append("&").append(s).append(";");
        }
        resp.setContentType("text/html");
        PrintWriter writer = resp.getWriter();
        writer.println("<div style=\"border-top:solid 1px\">Testing range:</div>");
        writer.print("<div><form action=\"" + resp.createActionURL() + "\" method=\"post\"\">" + "<input type=\"text\" name=\"from\" value=\"" + from + "\"/>" + "<input type=\"text\" name=\"to\" value=\"" + to + "\"/>" + "<input type=\"submit\" value=\"change\"/>" + "</form>" + "</div>");
        writer.println("<div style=\"border-top:solid 1px\">Test processAction() with a textarea field:</div>");
        writer.println("<div><form action=\"" + resp.createActionURL() + "\" accept-charset=\"" + resp.getCharacterEncoding() + "\" method=\"post\">" + "<input type=\"hidden\" name=\"from\" value=\"" + from + "\"/>" + "<input type=\"hidden\" name=\"to\" value=\"" + to + "\"/>" + "<textarea name=\"text\" cols=\"20\" rows=\"10\" wrap=\"virtual\">" + escapedText + "</textarea>" + "<input type=\"submit\" value=\"check\"/>" + "</form>" + "</div>");
        writer.println("<div style=\"border-top:solid 1px\">Test processAction() with a text field:</div>");
        writer.println("<div><form action=\"" + resp.createActionURL() + "\" accept-charset=\"" + resp.getCharacterEncoding() + "\" method=\"post\">" + "<input type=\"hidden\" name=\"from\" value=\"" + from + "\"/>" + "<input type=\"hidden\" name=\"to\" value=\"" + to + "\"/>" + "<input type=\"text\" name=\"text\" value=\"" + escapedText + "\"/>" + "<input type=\"submit\" value=\"check\"/>" + "</form>" + "</div>");
        PortletURL url = resp.createActionURL();
        url.setParameter("text", text.toString());
        writer.println("<div style=\"border-top:solid 1px\">Test processAction() with a portlet parameter:</div>");
        writer.println("<div><form action=\"" + url + "\" accept-charset=\"" + resp.getCharacterEncoding() + "\" method=\"post\">" + "<input type=\"hidden\" name=\"from\" value=\"" + from + "\"/>" + "<input type=\"hidden\" name=\"to\" value=\"" + to + "\"/>" + "<input type=\"submit\" value=\"check\"/>" + "</form>" + "</div>");
        PortletURL url2 = resp.createActionURL();
        url2.setParameter("text", text.toString());
        url2.setParameter("from", "" + from);
        url2.setParameter("to", "" + to);
        writer.println("<div style=\"border-top:solid 1px\"><a href=\"" + url2 + "\">Test</a> processAction() with a portlet parameter:</div>");
        if (same != null) {
            writer.print("<div style=\"color:red;margin-top:2em;margin-bottom:2em\">Test result: ");
            if (same == Boolean.TRUE) {
                writer.print("The input matched the expected result");
            } else if (same == Boolean.FALSE) {
                writer.print("The input did not matched the expected result");
            }
            writer.print("</div>");
        }
        writer.close();
    }

    public static boolean useChar(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }
}

