/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.samples.basic;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class SessionPortlet
extends GenericPortlet {
    public void processAction(ActionRequest req, ActionResponse resp) throws PortletException, IOException {
        boolean portletScope;
        String name = req.getParameter("name");
        String value = req.getParameter("value");
        boolean bl = portletScope = req.getParameter("portlet") != null;
        if (name != null && value != null) {
            req.getPortletSession().setAttribute(name, (Object)value, portletScope ? 2 : 1);
        }
        if (req.getParameter("invalidate") != null) {
            req.getPortletSession().invalidate();
        }
    }

    public void render(RenderRequest req, RenderResponse resp) throws PortletException, IOException {
        PortletSession session = req.getPortletSession(false);
        PortletURL purl = resp.createActionURL();
        resp.setContentType("text/html");
        PrintWriter writer = resp.getWriter();
        if (session == null) {
            writer.println("No session");
        } else {
            writer.println("Session id = " + session.getId());
            writer.println("<br/>");
            this.print(session, 2, writer);
            writer.println("<br/>");
            this.print(session, 1, writer);
            writer.println("<br/>");
        }
        writer.println("<form action=\"" + purl.toString() + "\" method=\"post\">");
        writer.println("<input type=\"text\" name=\"name\"/>");
        writer.println("<input type=\"text\" name=\"value\"/>");
        writer.println("<input type=\"submit\" name=\"portlet\" value=\"Add to portlet scope\"/>");
        writer.println("<input type=\"submit\" name=\"application\" value=\"Add to application scope\"/>");
        writer.println("</form><br/>");
        purl.setParameter("invalidate", "true");
        writer.println("<a href=\"" + purl.toString() + "\">invalidate</a><br/>");
    }

    private void print(PortletSession session, int scope, PrintWriter writer) {
        String scopeName = 2 == scope ? "portlet" : "application";
        writer.println("<p style='border-bottom: 2px dashed #999;'>Session attributes for " + scopeName + " scope:</p>");
        Enumeration e = session.getAttributeNames(scope);
        if (e.hasMoreElements()) {
            writer.println("<table style='border: 1px solid #333;'>");
            writer.println("<tr class='portlet-table-header'><th>name</th><th>value</th>");
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object value = session.getAttribute(name, scope);
                writer.println("<tr><td>" + name + "</td><td>" + value + "</td>");
            }
            writer.println("</table>");
        } else {
            writer.println("<p>No attributes in " + scopeName + " scope!</p>");
        }
    }
}

