/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit;

import java.io.Serializable;
import org.gatein.pc.test.unit.FailureType;

public class Failure
implements Serializable {
    private final String message;
    private final Throwable cause;
    private final FailureType type;
    private final Throwable stackTrace;

    public Failure(String message, FailureType type) {
        this(message, null, type);
    }

    public Failure(Throwable cause, FailureType type) {
        this(null, cause, type);
    }

    public Failure(String message, Throwable cause, FailureType type) {
        if (message == null && cause != null) {
            message = cause.getMessage();
        }
        this.message = message;
        this.cause = cause;
        this.type = type;
        this.stackTrace = cause != null ? cause : new Exception("Failed at");
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public Throwable getStackTrace() {
        return this.stackTrace;
    }

    public FailureType getType() {
        return this.type;
    }

    public static Failure createFailure(Throwable cause) {
        if (cause instanceof AssertionError) {
            return new Failure(cause, FailureType.ASSERTION);
        }
        return new Failure(cause, FailureType.ERROR);
    }

    public static Failure createFailure(String message, Throwable cause) {
        if (cause instanceof AssertionError) {
            return new Failure(message, cause, FailureType.ASSERTION);
        }
        return new Failure(message, cause, FailureType.ERROR);
    }

    public static Failure createErrorFailure(String message) {
        return new Failure(message, FailureType.ERROR);
    }

    public static Failure createErrorFailure(String message, Throwable cause) {
        return new Failure(message, cause, FailureType.ERROR);
    }

    public static Failure createErrorFailure(Throwable cause) {
        return new Failure(cause, FailureType.ERROR);
    }

    public static Failure createAssertionFailure(Throwable cause) {
        return new Failure(cause, FailureType.ASSERTION);
    }

    public static Failure createAssertionFailure(String message) {
        return new Failure(message, FailureType.ASSERTION);
    }
}

