/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit.web;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.test.unit.Failure;
import org.gatein.pc.test.unit.JoinPoint;
import org.gatein.pc.test.unit.JoinPointType;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.PortletTestServlet;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletEventTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.PortletResourceTestAction;
import org.gatein.pc.test.unit.actions.PortletTestAction;
import org.gatein.pc.test.unit.protocol.DriverServlet;
import org.gatein.pc.test.unit.protocol.response.FailureResponse;
import org.gatein.pc.test.unit.protocol.response.Response;

public abstract class AbstractUniversalTestPortlet
implements Portlet,
EventPortlet,
ResourceServingPortlet {
    private final Logger log = this.createLogger();
    private final JoinPoint renderJoinPoint = JoinPoint.createJoinPoint(this.getClass(), JoinPointType.PORTLET_RENDER);
    private final JoinPoint eventJoinPoint = JoinPoint.createJoinPoint(this.getClass(), JoinPointType.PORTLET_EVENT);
    private final JoinPoint actionJoinPoint = JoinPoint.createJoinPoint(this.getClass(), JoinPointType.PORTLET_ACTION);
    private final JoinPoint resourceJoinPoint = JoinPoint.createJoinPoint(this.getClass(), JoinPointType.PORTLET_RESOURCE);
    private PortletConfig config;
    private RuntimeStatus runtimeStatus = RuntimeStatus.INSTANTIATED;

    public static String getPortletName() {
        StackTraceElement elt = new Throwable().getStackTrace()[1];
        String className = elt.getClassName();
        int index = className.indexOf(46);
        if (index != -1) {
            className = className.substring(index + 1);
        }
        return className;
    }

    public void init(PortletConfig config) throws PortletException {
        this.config = config;
        this.runtimeStatus = RuntimeStatus.STARTED;
    }

    public PortletConfig getPortletConfig() {
        return this.config;
    }

    public PortletContext getPortletContext() {
        return this.config.getPortletContext();
    }

    public final void processAction(ActionRequest req, ActionResponse resp) throws PortletException, IOException {
        PortletTestContext ctx = DriverServlet.getPortletTestContext();
        this.log.debug((Object)("JoinPoint '" + this.actionJoinPoint + "' invoked for '" + ctx.getTestName() + "' testId and '" + ctx.getRequestCount() + "' request count"));
        PortletTestCase portletTestCase = this.getSequence(ctx.getTestName());
        if (portletTestCase != null) {
            Response response;
            TestAction action = portletTestCase.getAction(ctx.getRequestCount(), this.actionJoinPoint);
            if (action instanceof PortletTestAction) {
                this.log.debug((Object)("Found action for jointpoint " + this.actionJoinPoint + " : " + action));
                response = ((PortletTestAction)action).execute(this, (PortletRequest)req, (PortletResponse)resp, ctx);
            } else if (action instanceof PortletActionTestAction) {
                this.log.debug((Object)("Found action for jointpoint " + this.actionJoinPoint + " : " + action));
                response = ((PortletActionTestAction)action).execute(this, req, resp, ctx);
            } else {
                response = new FailureResponse(Failure.createAssertionFailure("Action for " + ctx.getRequestCount() + " " + this.actionJoinPoint + " does not have the right type but has the type " + action.getClass().getName()));
            }
            if (response != null) {
                ctx.updateResponse(response);
            }
        }
    }

    public void processEvent(EventRequest req, EventResponse resp) throws PortletException, IOException {
        PortletTestContext ctx = DriverServlet.getPortletTestContext();
        if (ctx.getResponse() == null) {
            TestAction action;
            this.log.debug((Object)("JoinPoint '" + this.eventJoinPoint + "' invoked for '" + ctx.getTestName() + "' testId and '" + ctx.getRequestCount() + "' request count"));
            PortletTestCase portletTestCase = this.getSequence(ctx.getTestName());
            if (portletTestCase != null && (action = portletTestCase.getAction(ctx.getRequestCount(), this.eventJoinPoint)) != null) {
                Response response = null;
                if (action instanceof PortletTestAction) {
                    this.log.debug((Object)("Found action for jointpoint " + this.eventJoinPoint + " : " + action));
                    response = ((PortletTestAction)action).execute(this, (PortletRequest)req, (PortletResponse)resp, ctx);
                } else if (action instanceof PortletEventTestAction) {
                    this.log.debug((Object)("Found action for jointpoint " + this.eventJoinPoint + " : " + action));
                    response = ((PortletEventTestAction)action).execute(this, req, resp, ctx);
                } else {
                    response = action == null ? new FailureResponse(Failure.createAssertionFailure("Action for " + ctx.getRequestCount() + " " + this.actionJoinPoint + " is null")) : new FailureResponse(Failure.createAssertionFailure("Action for " + ctx.getRequestCount() + " " + this.actionJoinPoint + " does not have the right type but has the type " + action.getClass().getName()));
                }
                if (response != null) {
                    ctx.updateResponse(response);
                }
            }
        }
    }

    public final void render(RenderRequest req, RenderResponse resp) throws PortletException, IOException {
        PortletTestContext ctx = DriverServlet.getPortletTestContext();
        this.log.debug((Object)("JoinPoint '" + this.renderJoinPoint + " invoked for '" + ctx.getTestName() + "' testId and '" + ctx.getRequestCount() + "' request count"));
        if (ctx.getRequestCount() == 0) {
            this.reset();
        }
        TestAction action = null;
        PortletTestCase portletTestCase = this.getSequence(ctx.getTestName());
        if (portletTestCase != null) {
            action = portletTestCase.getAction(ctx.getRequestCount(), this.renderJoinPoint);
        }
        if (action != null) {
            Response response;
            if (action instanceof PortletTestAction) {
                this.log.debug((Object)("Found action for joinpoint " + this.renderJoinPoint + " : " + action));
                response = ((PortletTestAction)action).execute(this, (PortletRequest)req, (PortletResponse)resp, ctx);
            } else if (action instanceof PortletRenderTestAction) {
                this.log.debug((Object)("Found action for joinpoint " + this.renderJoinPoint + " : " + action));
                response = ((PortletRenderTestAction)action).execute(this, req, resp, ctx);
            } else {
                response = action == null ? new FailureResponse(Failure.createAssertionFailure("Action for " + ctx.getRequestCount() + " " + this.resourceJoinPoint + " is null")) : new FailureResponse(Failure.createAssertionFailure("Action for " + ctx.getRequestCount() + " " + this.resourceJoinPoint + " does not have the right type but has the type " + action.getClass().getName()));
            }
            if (response != null) {
                ctx.updateResponse(response);
            }
        } else {
            resp.setProperty("portlet.expiration-cache", "0");
        }
    }

    public void serveResource(ResourceRequest req, ResourceResponse resp) throws PortletException, IOException {
        Response response;
        PortletTestContext ctx = DriverServlet.getPortletTestContext();
        this.log.debug((Object)("JoinPoint '" + this.resourceJoinPoint + " invoked for '" + ctx.getTestName() + "' testId and '" + ctx.getRequestCount() + "' request count"));
        TestAction action = null;
        PortletTestCase portletTestCase = this.getSequence(ctx.getTestName());
        if (portletTestCase != null) {
            action = portletTestCase.getAction(ctx.getRequestCount(), this.resourceJoinPoint);
        }
        if (action instanceof PortletTestAction) {
            this.log.debug((Object)("Found action for joinpoint " + this.resourceJoinPoint + " : " + action));
            response = ((PortletTestAction)action).execute(this, (PortletRequest)req, (PortletResponse)resp, ctx);
        } else if (action instanceof PortletResourceTestAction) {
            this.log.debug((Object)("Found action for joinpoint " + this.resourceJoinPoint + " : " + action));
            response = ((PortletResourceTestAction)action).execute(this, req, resp, ctx);
        } else {
            response = action == null ? new FailureResponse(Failure.createAssertionFailure("Action for " + ctx.getRequestCount() + " " + this.resourceJoinPoint + " is null")) : new FailureResponse(Failure.createAssertionFailure("Action for " + ctx.getRequestCount() + " " + this.resourceJoinPoint + " does not have the right type but has the type " + action.getClass().getName()));
        }
        if (response != null) {
            ctx.updateResponse(response);
        }
    }

    public void destroy() {
        this.runtimeStatus = RuntimeStatus.STOPPED;
    }

    public RuntimeStatus getRuntimeStatus() {
        return this.runtimeStatus;
    }

    private PortletTestCase getSequence(String testId) throws PortletException {
        PortletTestCase testCase = PortletTestServlet.getTestCase(testId);
        if (testCase == null) {
            this.log.error((Object)"No test suite object found in current context");
            throw new PortletException("No test suite object found in context");
        }
        return testCase;
    }

    public JoinPoint getActionJointpoint() {
        return this.actionJoinPoint;
    }

    public JoinPoint getRenderJointpoint() {
        return this.renderJoinPoint;
    }

    protected void reset() {
    }

    protected Logger createLogger() {
        if (this.log != null) {
            throw new IllegalStateException("The logger should not be re");
        }
        return LoggerFactory.getLogger(this.getClass());
    }

    public final Logger getLogger() {
        return this.log;
    }

    public static enum RuntimeStatus {
        INSTANTIATED,
        STARTED,
        STOPPED;

    }
}

