/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.url;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gatein.common.util.ParameterMap;
import org.gatein.pc.test.url.CodecBuilder;
import org.gatein.pc.test.url.ParameterDecoder;

public class DecoderTestCase
extends TestCase {
    Tester tester;

    public void setUp() throws Exception {
        this.tester = new Tester();
    }

    public void testNoMeta() {
        this.tester.assertActual(0);
        this.tester.assertMeta(0);
        this.tester.parameter("action", "0");
        this.tester.checkAndReset();
        this.tester.parameter("m1", "a");
        this.tester.assertActual(1).assertActual("m1", new String[]{"a"});
        this.tester.assertMeta(0);
        this.tester.parameter("action", "0");
        this.tester.checkAndReset();
    }

    public void testNoMetaCorruption() {
        this.tester.parameter("action", "a").assertFailed().checkAndReset();
        this.tester.parameter("action", "1").assertFailed().checkAndReset();
    }

    public void testOneMeta() {
        this.tester.builder.addMetaParameter("m1");
        this.tester.assertActual(0);
        this.tester.assertMeta(0);
        this.tester.parameter("action", "0");
        this.tester.checkAndReset();
        this.tester.parameter("m1", "a");
        this.tester.assertActual(1).assertActual("m1", new String[]{"a"});
        this.tester.assertMeta(0);
        this.tester.parameter("action", "0");
        this.tester.checkAndReset();
        this.tester.parameter("action", "1").parameter("m1", "foo");
        this.tester.assertActual(0);
        this.tester.assertMeta(1).assertMeta("m1", new String[]{"foo"});
        this.tester.checkAndReset();
        this.tester.parameter("action", "1").parameter("m1", new String[]{"foo", "a"});
        this.tester.assertActual(1).assertActual("m1", new String[]{"a"});
        this.tester.assertMeta(1).assertMeta("m1", new String[]{"foo"});
        this.tester.checkAndReset();
        this.tester.parameter("m2", "b");
        this.tester.assertActual(1).assertActual("m2", new String[]{"b"});
        this.tester.assertMeta(0);
        this.tester.parameter("action", "0");
        this.tester.checkAndReset();
        this.tester.parameter("m1", "a").parameter("m2", "b");
        this.tester.assertActual(2).assertActual("m1", new String[]{"a"}).assertActual("m2", new String[]{"b"});
        this.tester.assertMeta(0);
        this.tester.parameter("action", "0");
        this.tester.checkAndReset();
        this.tester.parameter("action", "1").parameter("m1", "foo").parameter("m2", "b");
        this.tester.assertActual(1).assertActual("m2", new String[]{"b"});
        this.tester.assertMeta(1).assertMeta("m1", new String[]{"foo"});
        this.tester.checkAndReset();
        this.tester.parameter("action", "1").parameter("m1", new String[]{"foo", "a"}).parameter("m2", "b");
        this.tester.assertActual(2).assertActual("m1", new String[]{"a"}).assertActual("m2", new String[]{"b"});
        this.tester.assertMeta(1).assertMeta("m1", new String[]{"foo"});
        this.tester.checkAndReset();
    }

    public void testOneMetaCorruption() {
        this.tester.builder.addMetaParameter("m1");
        this.tester.parameter("action", "a").assertFailed().checkAndReset();
        this.tester.parameter("action", "1").assertFailed().checkAndReset();
        this.tester.parameter("action", "10").assertFailed().checkAndReset();
        this.tester.parameter("action", "a").assertFailed().checkAndReset();
        this.tester.parameter("action", "10").parameter("m1", "foo").assertFailed().checkAndReset();
    }

    public void testTwoMeta() {
        this.tester.builder.addMetaParameter("m1");
        this.tester.builder.addMetaParameter("m2");
        this.tester.assertActual(0);
        this.tester.assertMeta(0);
        this.tester.parameter("action", "0");
        this.tester.checkAndReset();
        this.tester.parameter("m1", "a");
        this.tester.assertActual(1).assertActual("m1", new String[]{"a"});
        this.tester.assertMeta(0);
        this.tester.parameter("action", "0");
        this.tester.checkAndReset();
        this.tester.parameter("m2", "b");
        this.tester.assertActual(1).assertActual("m2", new String[]{"b"});
        this.tester.assertMeta(0);
        this.tester.parameter("action", "0");
        this.tester.checkAndReset();
        this.tester.parameter("m1", "a").parameter("m2", "b");
        this.tester.assertActual(2).assertActual("m1", new String[]{"a"}).assertActual("m2", new String[]{"b"});
        this.tester.assertMeta(0);
        this.tester.parameter("action", "0");
        this.tester.checkAndReset();
        this.tester.parameter("action", "10").parameter("m1", "foo");
        this.tester.assertActual(0);
        this.tester.assertMeta(1).assertMeta("m1", new String[]{"foo"});
        this.tester.checkAndReset();
        this.tester.parameter("action", "10").parameter("m1", new String[]{"foo", "a"});
        this.tester.assertActual(1).assertActual("m1", new String[]{"a"});
        this.tester.assertMeta(1).assertMeta("m1", new String[]{"foo"});
        this.tester.checkAndReset();
        this.tester.parameter("action", "10").parameter("m1", "foo").parameter("m2", "b");
        this.tester.assertActual(1).assertActual("m2", new String[]{"b"});
        this.tester.assertMeta(1).assertMeta("m1", new String[]{"foo"});
        this.tester.checkAndReset();
        this.tester.parameter("action", "10").parameter("m1", new String[]{"foo", "a"}).parameter("m2", "b");
        this.tester.assertActual(2).assertActual("m1", new String[]{"a"}).assertActual("m2", new String[]{"b"});
        this.tester.assertMeta(1).assertMeta("m1", new String[]{"foo"});
        this.tester.checkAndReset();
        this.tester.parameter("action", "1").parameter("m2", "bar");
        this.tester.assertActual(0);
        this.tester.assertMeta(1).assertMeta("m2", new String[]{"bar"});
        this.tester.checkAndReset();
        this.tester.parameter("action", "1").parameter("m1", "a").parameter("m2", "bar");
        this.tester.assertActual(1).assertActual("m1", new String[]{"a"});
        this.tester.assertMeta(1).assertMeta("m2", new String[]{"bar"});
        this.tester.checkAndReset();
        this.tester.parameter("action", "1").parameter("m2", new String[]{"bar", "b"});
        this.tester.assertActual(1).assertActual("m2", new String[]{"b"});
        this.tester.assertMeta(1).assertMeta("m2", new String[]{"bar"});
        this.tester.checkAndReset();
        this.tester.parameter("action", "1").parameter("m1", "a").parameter("m2", new String[]{"bar", "b"});
        this.tester.assertActual(2).assertActual("m1", new String[]{"a"}).assertActual("m2", new String[]{"b"});
        this.tester.assertMeta(1).assertMeta("m2", new String[]{"bar"});
        this.tester.checkAndReset();
        this.tester.parameter("action", "11").parameter("m1", "foo").parameter("m2", "bar");
        this.tester.assertActual(0);
        this.tester.assertMeta(2).assertMeta("m1", new String[]{"foo"}).assertMeta("m2", new String[]{"bar"});
        this.tester.checkAndReset();
        this.tester.parameter("action", "11").parameter("m1", new String[]{"foo", "a"}).parameter("m2", "bar");
        this.tester.assertActual(1).assertActual("m1", new String[]{"a"});
        this.tester.assertMeta(2).assertMeta("m1", new String[]{"foo"}).assertMeta("m2", new String[]{"bar"});
        this.tester.checkAndReset();
        this.tester.parameter("action", "11").parameter("m1", "foo").parameter("m2", new String[]{"bar", "b"});
        this.tester.assertActual(1).assertActual("m2", new String[]{"b"});
        this.tester.assertMeta(2).assertMeta("m1", new String[]{"foo"}).assertMeta("m2", new String[]{"bar"});
        this.tester.checkAndReset();
        this.tester.parameter("action", "11").parameter("m1", new String[]{"foo", "a"}).parameter("m2", new String[]{"bar", "b"});
        this.tester.assertActual(2).assertActual("m1", new String[]{"a"}).assertActual("m2", new String[]{"b"});
        this.tester.assertMeta(2).assertMeta("m1", new String[]{"foo"}).assertMeta("m2", new String[]{"bar"});
        this.tester.checkAndReset();
    }

    private static class Tester {
        ArrayList assertions = new ArrayList();
        CodecBuilder builder = new CodecBuilder("action");
        ParameterMap parameters = new ParameterMap();
        ParameterMap actualParameters = new ParameterMap();
        ParameterMap metaParameters = new ParameterMap();
        boolean failed;

        private Tester() {
        }

        public void check() {
            ParameterDecoder decoder = this.builder.createDecoder();
            try {
                decoder.decode(this.parameters);
                this.failed = false;
                this.actualParameters = decoder.getActualParameters();
                this.metaParameters = decoder.getMetaParameters();
            }
            catch (IllegalArgumentException e) {
                this.failed = true;
            }
            for (int i = 0; i < this.assertions.size(); ++i) {
                Assertion assertion = (Assertion)this.assertions.get(i);
                assertion.doAssert();
            }
        }

        public void checkAndReset() {
            this.check();
            this.parameters.clear();
            this.assertions.clear();
        }

        public Tester parameter(String name, String value) {
            if (value == null) {
                this.parameters.remove((Object)name);
            } else {
                this.parameters.setValue(name, value);
            }
            return this;
        }

        public Tester parameter(String name, String[] values) {
            this.parameters.setValues(name, values);
            return this;
        }

        public Tester assertActual(final int size) {
            this.assertions.add(new Assertion(){

                @Override
                public void doAssert() {
                    Assert.assertFalse((boolean)Tester.this.failed);
                    Assert.assertEquals((int)size, (int)Tester.this.actualParameters.size());
                }
            });
            return this;
        }

        public Tester assertActual(final String name, final String[] values) {
            this.assertions.add(new Assertion(){

                @Override
                public void doAssert() {
                    Assert.assertFalse((boolean)Tester.this.failed);
                    Assert.assertEquals(Arrays.asList(values), Arrays.asList(Tester.this.actualParameters.getValues(name)));
                }
            });
            return this;
        }

        public Tester assertMeta(final int size) {
            this.assertions.add(new Assertion(){

                @Override
                public void doAssert() {
                    Assert.assertFalse((boolean)Tester.this.failed);
                    Assert.assertEquals((int)size, (int)Tester.this.metaParameters.size());
                }
            });
            return this;
        }

        public Tester assertMeta(final String name, final String[] values) {
            this.assertions.add(new Assertion(){

                @Override
                public void doAssert() {
                    Assert.assertFalse((boolean)Tester.this.failed);
                    Assert.assertEquals(Arrays.asList(values), Arrays.asList(Tester.this.metaParameters.getValues(name)));
                }
            });
            return this;
        }

        public Tester assertFailed() {
            this.assertions.add(new Assertion(){

                @Override
                public void doAssert() {
                    Assert.assertTrue((boolean)Tester.this.failed);
                }
            });
            return this;
        }

        private static interface Assertion {
            public void doAssert();
        }
    }
}

