/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr168.tck.portleturl;

import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;

@TestCase(value={Assertion.JSR168_27, Assertion.JSR168_28, Assertion.JSR168_29})
public class PortletURLParameters {
    public PortletURLParameters(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                PortletURL url = response.createActionURL();
                url.setParameter("key1", "some strange value to overwrite");
                url.setParameter("key2", "some strange value to overwrite 2");
                url.setParameter("key1", "k1value1");
                url.setParameter("key2", new String[]{"k2value1", "k2value2", "k2value3"});
                return new InvokeGetResponse(url.toString());
            }
        });
        seq.bindAction(1, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) {
                Assert.assertEquals((Object)"k1value1", (Object)request.getParameter("key1"));
                Assert.assertEquals((Object[])new String[]{"k2value1", "k2value2", "k2value3"}, (Object[])request.getParameterValues("key2"));
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                PortletURL url = response.createActionURL();
                url.setParameter("key3", "some strange value to overwrite");
                url.setParameter("key4", "some strange value to overwrite 2");
                HashMap<String, String[]> map = new HashMap<String, String[]>();
                map.put("key3", new String[]{"k3value1"});
                map.put("key4", new String[]{"k4value1", "k4value2", "k4value3"});
                url.setParameters(map);
                return new InvokeGetResponse(url.toString());
            }
        });
        seq.bindAction(2, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) {
                Assert.assertNull((Object)request.getParameter("key1"));
                Assert.assertNull((Object)request.getParameter("key2"));
                Assert.assertEquals((Object)"k3value1", (Object)request.getParameter("key3"));
                Assert.assertEquals((Object[])new String[]{"k4value1", "k4value2", "k4value3"}, (Object[])request.getParameterValues("key4"));
            }
        });
        seq.bindAction(2, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                PortletURL url = response.createRenderURL();
                HashMap<String, String[]> map = new HashMap<String, String[]>();
                url.setParameter("key5", "some strange value to overwrite");
                url.setParameter("key6", "some strange value to overwrite 2");
                map.put("key5", new String[]{"k5value1"});
                map.put("key6", new String[]{"k6value1", "k6value2", "k6value3"});
                url.setParameters(map);
                url.setParameter("key7", new String[]{"k7value1", "k7value2"});
                return new InvokeGetResponse(url.toString());
            }
        });
        seq.bindAction(3, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                Assert.assertNull((Object)request.getParameter("key1"));
                Assert.assertNull((Object)request.getParameter("key2"));
                Assert.assertNull((Object)request.getParameter("key3"));
                Assert.assertNull((Object)request.getParameter("key4"));
                Assert.assertEquals((Object)"k5value1", (Object)request.getParameter("key5"));
                Assert.assertEquals((Object[])new String[]{"k6value1", "k6value2", "k6value3"}, (Object[])request.getParameterValues("key6"));
                Assert.assertEquals((Object[])new String[]{"k7value1", "k7value2"}, (Object[])request.getParameterValues("key7"));
                return new EndTestResponse();
            }
        });
    }
}

