/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.tck.portleturl;

import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import org.gatein.pc.test.unit.Assert;

public class PortletURLSnapshot {
    private static final int ACTION = 0;
    private static final int RENDER = 1;
    private static final int RESOURCE = 2;
    final String source;
    final int type;
    final PortletMode portletMode;
    final WindowState windowState;
    final Map<String, String[]> parameters;
    final String cacheability;

    public static PortletURLSnapshot createActionURL(String source, PortletURL actionURL) {
        return new PortletURLSnapshot(source, 0, actionURL);
    }

    public static PortletURLSnapshot createRenderURL(String source, PortletURL renderURL) {
        return new PortletURLSnapshot(source, 1, renderURL);
    }

    public static PortletURLSnapshot createResourceURL(String source, ResourceURL resourceURL) {
        return new PortletURLSnapshot(source, resourceURL);
    }

    public static PortletURLSnapshot createActionURL(String source, PortletMode portletMode, WindowState windowState, Map<String, String[]> parameters) {
        return new PortletURLSnapshot(source, 0, portletMode, windowState, parameters);
    }

    public static PortletURLSnapshot createRenderURL(String source, PortletMode portletMode, WindowState windowState, Map<String, String[]> parameters) {
        return new PortletURLSnapshot(source, 1, portletMode, windowState, parameters);
    }

    public static PortletURLSnapshot createResourceURL(String source, Map<String, String[]> parameters, String cacheability) {
        return new PortletURLSnapshot(source, parameters, cacheability);
    }

    private PortletURLSnapshot(String source, int type, PortletURL portletURL) {
        this.source = source;
        this.type = type;
        this.portletMode = portletURL.getPortletMode();
        this.windowState = portletURL.getWindowState();
        this.parameters = portletURL.getParameterMap();
        this.cacheability = null;
    }

    private PortletURLSnapshot(String source, ResourceURL resourceURL) {
        this.source = source;
        this.type = 2;
        this.portletMode = null;
        this.windowState = null;
        this.parameters = resourceURL.getParameterMap();
        this.cacheability = resourceURL.getCacheability();
    }

    private PortletURLSnapshot(String source, int type, PortletMode portletMode, WindowState windowState, Map<String, String[]> parameters) {
        this.source = source;
        this.type = type;
        this.portletMode = portletMode;
        this.windowState = windowState;
        this.parameters = parameters;
        this.cacheability = null;
    }

    private PortletURLSnapshot(String source, Map<String, String[]> parameters, String cacheability) {
        this.source = source;
        this.type = 2;
        this.portletMode = null;
        this.windowState = null;
        this.parameters = parameters;
        this.cacheability = cacheability;
    }

    public void assertEquals(PortletURLSnapshot actual) {
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)this.source, (Object)actual.source);
        Assert.assertEquals((Object)this.type, (Object)actual.type);
        Assert.assertEquals(this.parameters.keySet(), actual.parameters.keySet());
        for (Map.Entry<String, String[]> entry : this.parameters.entrySet()) {
            Assert.assertEquals((Object[])entry.getValue(), (Object[])actual.parameters.get(entry.getKey()));
        }
        if (this.type == 2) {
            Assert.assertEquals((Object)this.cacheability, (Object)actual.cacheability);
        } else {
            Assert.assertEquals((Object)this.portletMode, (Object)actual.portletMode);
            Assert.assertEquals((Object)this.windowState, (Object)actual.windowState);
        }
    }
}

