/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.samples.resourceserving;

import java.io.IOException;
import java.io.PrintWriter;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;

public class ResourceServingDemoPortlet
extends GenericPortlet {
    private static final String HTML = "html";
    private static final String EXCEPTION = "exception";
    private static final String NOT_FOUND = "404";
    private static final String NO_OP = "noop";
    private static String[] msg = new String[]{"HTML", "Exception", "Not Found", "No op"};
    private static String[] behaviors = new String[]{"html", "exception", "404", "noop"};

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        ResourceURL url = response.createResourceURL();
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.print("<p>This portlet shows how a resource serving portlet can modify the response</p>");
        writer.print("<ul>");
        for (int i = 0; i < msg.length; ++i) {
            url.setParameter("behavior", behaviors[i]);
            writer.print("<li><a href='" + url + "'>" + msg[i] + "</a></li>");
        }
        writer.print("</ul>");
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        String behavior = request.getParameter("behavior");
        if (HTML.equals(behavior)) {
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            writer.print("<html><body>Hello World</body><html>");
        } else {
            if (EXCEPTION.equals(behavior)) {
                throw new PortletException("Don't freak out");
            }
            if (NOT_FOUND.equals(behavior)) {
                response.setProperty("portlet.http-status-code", NOT_FOUND);
                PrintWriter writer = response.getWriter();
                writer.print("<html><body>Not Found</body><html>");
            }
        }
    }
}

