/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.ProtectedContainer;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageError;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageServiceException;
import org.exoplatform.portal.mop.page.PageServiceImpl;
import org.exoplatform.portal.mop.page.PageServiceWrapper;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.gatein.api.ApiException;
import org.gatein.api.Comparators;
import org.gatein.api.EntityAlreadyExistsException;
import org.gatein.api.EntityNotFoundException;
import org.gatein.api.Portal;
import org.gatein.api.Util;
import org.gatein.api.common.Filter;
import org.gatein.api.common.Pagination;
import org.gatein.api.common.Sorting;
import org.gatein.api.internal.Parameters;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.NavigationImpl;
import org.gatein.api.oauth.OAuthProvider;
import org.gatein.api.oauth.OAuthProviderAccessor;
import org.gatein.api.page.Page;
import org.gatein.api.page.PageId;
import org.gatein.api.page.PageImpl;
import org.gatein.api.page.PageQuery;
import org.gatein.api.security.Membership;
import org.gatein.api.security.Permission;
import org.gatein.api.security.User;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteId;
import org.gatein.api.site.SiteImpl;
import org.gatein.api.site.SiteQuery;
import org.gatein.api.site.SiteType;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class PortalImpl
implements Portal {
    private static final Query<PortalConfig> SITES = new Query(org.exoplatform.portal.mop.SiteType.PORTAL.getName(), null, PortalConfig.class);
    private static final Query<PortalConfig> SPACES = new Query(org.exoplatform.portal.mop.SiteType.GROUP.getName(), null, PortalConfig.class);
    private static final Query<PortalConfig> DASHBOARDS = new Query(org.exoplatform.portal.mop.SiteType.USER.getName(), null, PortalConfig.class);
    static final Logger log = LoggerFactory.getLogger((String)"org.gatein.api");
    private final DataStorage dataStorage;
    private final PageService pageService;
    private final NavigationService navigationService;
    private final DescriptionService descriptionService;
    private final ResourceBundleManager bundleManager;
    private final UserACL acl;
    private final Authenticator authenticator;
    private final IdentityRegistry identityRegistry;
    private final UserPortalConfigService userPortalConfigService;
    private final OAuthProviderAccessor oauthProviderAccessor;

    public PortalImpl(DataStorage dataStorage, PageService pageService, NavigationService navigationService, DescriptionService descriptionService, ResourceBundleManager bundleManager, Authenticator authenticator, IdentityRegistry identityRegistry, UserACL acl, UserPortalConfigService userPortalConfigService, OAuthProviderAccessor oauthProviderAccessor) {
        this.dataStorage = dataStorage;
        this.pageService = pageService;
        this.navigationService = navigationService;
        this.descriptionService = descriptionService;
        this.bundleManager = bundleManager;
        this.authenticator = authenticator;
        this.identityRegistry = identityRegistry;
        this.acl = acl;
        this.userPortalConfigService = userPortalConfigService;
        this.oauthProviderAccessor = oauthProviderAccessor;
    }

    public Site getSite(SiteId siteId) {
        Parameters.requireNonNull((Object)siteId, (String)"siteId");
        SiteKey siteKey = Util.from(siteId);
        try {
            PortalConfig portalConfig = this.dataStorage.getPortalConfig(siteKey.getTypeName(), siteKey.getName());
            return portalConfig == null ? null : new SiteImpl(portalConfig);
        }
        catch (Throwable e) {
            throw new ApiException("Failed to get site", e);
        }
    }

    public Site createSite(SiteId siteId) {
        String template = this.userPortalConfigService.getDefaultPortalTemplate();
        if (template == null) {
            template = "";
        }
        return this.createSite(siteId, template);
    }

    public Site createSite(SiteId siteId, String templateName) throws IllegalArgumentException, EntityAlreadyExistsException {
        if (this.getSite(siteId) != null) {
            throw new EntityAlreadyExistsException("Cannot create site. Site " + siteId + " already exists.");
        }
        Parameters.requireNonNull((Object)templateName, (String)"templateName");
        return new SiteImpl(siteId, templateName);
    }

    public List<Site> findSites(SiteQuery query) {
        Parameters.requireNonNull((Object)query, (String)"query");
        Pagination pagination = query.getPagination();
        if (pagination != null && query.getSiteTypes().size() > 1) {
            pagination = null;
            log.warn((Object)"Pagination is not supported internally for SiteQuery's with multiple site types. Therefore this query has the possibility to perform poorly.");
        }
        boolean includeAll = query.isIncludeEmptySites();
        List<Site> sites = new ArrayList<Site>();
        for (SiteType type : query.getSiteTypes()) {
            List<Site> sitesFound;
            switch (type) {
                case SITE: {
                    sitesFound = this.findSites(pagination, SITES, Comparators.site((Sorting<Site>)query.getSorting()), includeAll);
                    break;
                }
                case SPACE: {
                    sitesFound = this.findSites(pagination, SPACES, Comparators.site((Sorting<Site>)query.getSorting()), includeAll);
                    break;
                }
                case DASHBOARD: {
                    sitesFound = this.findSites(pagination, DASHBOARDS, Comparators.site((Sorting<Site>)query.getSorting()), includeAll);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            sites.addAll(sitesFound);
            if (pagination == null || sites.size() < pagination.getLimit()) continue;
            break;
        }
        PortalImpl.filter(sites, query.getFilter());
        if (query.getSiteTypes().size() > 1) {
            sites = PortalImpl.paginate(sites, query.getPagination());
        }
        return sites;
    }

    private List<Site> findSites(Pagination pagination, Query<PortalConfig> query, Comparator<PortalConfig> comparator, boolean includeAllSites) {
        try {
            if (pagination != null) {
                ListAccess access = this.dataStorage.find2(query, comparator);
                int size = access.getSize();
                int offset = pagination.getOffset();
                int limit = pagination.getLimit();
                if (offset >= size) {
                    return Collections.emptyList();
                }
                PortalConfig[] sites = this.loadSites(includeAllSites, (ListAccess<PortalConfig>)access, size, offset, limit);
                return PortalImpl.fromList(Arrays.asList(sites).subList(pagination.getOffset(), sites.length));
            }
            return PortalImpl.fromList(this.dataStorage.find(query, comparator).getAll());
        }
        catch (Throwable e) {
            throw new ApiException("Failed to query for sites", e);
        }
    }

    public void saveSite(Site site) {
        Parameters.requireNonNull((Object)site, (String)"site");
        ((SiteImpl)site).save(this.dataStorage, this.userPortalConfigService);
    }

    public boolean removeSite(SiteId siteId) {
        Site site = this.getSite(siteId);
        if (site == null) {
            return false;
        }
        SiteKey siteKey = Util.from((SiteId)Parameters.requireNonNull((Object)siteId, (String)"siteId"));
        PortalConfig data = new PortalConfig(siteKey.getTypeName(), siteKey.getName());
        try {
            this.dataStorage.remove(data);
            return true;
        }
        catch (Throwable t) {
            throw new ApiException("Failed to remove site " + siteId, t);
        }
    }

    public Navigation getNavigation(SiteId siteId) {
        Parameters.requireNonNull((Object)siteId, (String)"siteId");
        try {
            NavigationContext ctx = this.navigationService.loadNavigation(Util.from(siteId));
            if (ctx == null) {
                return null;
            }
            return new NavigationImpl(siteId, this.navigationService, ctx, this.descriptionService, this.bundleManager);
        }
        catch (Throwable t) {
            throw new ApiException("Failed to load navigation", t);
        }
    }

    public Page getPage(PageId pageId) {
        Parameters.requireNonNull((Object)pageId, (String)"pageId");
        try {
            PageContext context = this.pageService.loadPage(Util.from(pageId));
            return context == null ? null : new PageImpl(context);
        }
        catch (Throwable e) {
            throw new ApiException("Failed to get page", e);
        }
    }

    public Page createPage(PageId pageId) throws EntityAlreadyExistsException {
        if (this.getPage(pageId) != null) {
            throw new EntityAlreadyExistsException("Cannot create page. Page " + pageId + " already exists.");
        }
        if (this.getSite(pageId.getSiteId()) == null) {
            throw new EntityNotFoundException("Site " + pageId.getSiteId() + " doesn't exist");
        }
        Permission edit = Permission.any((String[])new String[]{"platform", "administrators"});
        List moveAppsPermissions = ProtectedContainer.DEFAULT_MOVE_APPLICATIONS_PERMISSIONS;
        List moveContainersPermissions = ProtectedContainer.DEFAULT_MOVE_CONTAINERS_PERMISSIONS;
        PageState pageState = new PageState(pageId.getPageName(), null, false, null, Arrays.asList(Util.from(Permission.everyone())), Util.from(edit)[0], moveAppsPermissions, moveContainersPermissions);
        PageImpl p = new PageImpl(new PageContext(Util.from(pageId), pageState));
        p.setCreate(true);
        return p;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Page> findPages(PageQuery query) {
        Iterator iterator;
        Pagination pagination = query.getPagination();
        if (pagination == null) {
            if (query.getSiteType() == null || query.getSiteName() == null) {
                throw new IllegalArgumentException("Pagination is required when site type or site name is null.");
            }
            SiteKey siteKey = Util.from(new SiteId(query.getSiteType(), query.getSiteName()));
            if (this.pageService instanceof PageServiceImpl) {
                iterator = ((PageServiceImpl)this.pageService).loadPages(siteKey).iterator();
            } else {
                if (!(this.pageService instanceof PageServiceWrapper)) throw new RuntimeException("Unable to retrieve all pages for " + siteKey);
                iterator = ((PageServiceWrapper)this.pageService).loadPages(siteKey).iterator();
            }
        } else {
            QueryResult result = this.pageService.findPages(pagination.getOffset(), pagination.getLimit(), Util.from(query.getSiteType()), query.getSiteName(), null, query.getDisplayName());
            iterator = result.iterator();
        }
        ArrayList<Page> pages = new ArrayList<Page>();
        while (iterator.hasNext()) {
            pages.add(new PageImpl((PageContext)iterator.next()));
        }
        PortalImpl.filter(pages, query.getFilter());
        return pages;
    }

    public void savePage(Page page) {
        Parameters.requireNonNull((Object)page, (String)"page");
        if (this.getSite(page.getSiteId()) == null) {
            throw new EntityNotFoundException("Site " + page.getSiteId() + " doesn't exist");
        }
        if (((PageImpl)page).isCreate() && this.getPage(page.getId()) != null) {
            throw new EntityAlreadyExistsException("Cannot create page. Page " + page.getId() + " already exists.");
        }
        PageContext context = ((PageImpl)page).getPageContext();
        try {
            this.pageService.savePage(context);
        }
        catch (Throwable t) {
            throw new ApiException("Failed to save page " + page.getId(), t);
        }
    }

    public boolean removePage(PageId pageId) {
        Parameters.requireNonNull((Object)pageId, (String)"pageId");
        try {
            return this.pageService.destroyPage(Util.from(pageId));
        }
        catch (PageServiceException e) {
            if (e.getError() == PageError.NO_SITE) {
                throw new EntityNotFoundException("Cannot remove page '" + pageId.getPageName() + "'. Site " + pageId.getSiteId() + " does not exist.");
            }
            throw new ApiException("Failed to remove page " + pageId, (Throwable)e);
        }
        catch (Throwable t) {
            throw new ApiException("Failed to remove page " + pageId, t);
        }
    }

    public boolean hasPermission(User user, Permission permission) {
        Identity identity;
        if (permission.isAccessibleToEveryone()) {
            return true;
        }
        if (user == User.anonymous()) {
            identity = new Identity(IdentityConstants.ANONIM);
        } else {
            try {
                identity = this.identityRegistry.getIdentity(user.getId());
            }
            catch (Throwable t) {
                throw new ApiException("Failed top retrieve identity", t);
            }
        }
        if (identity == null) {
            try {
                identity = this.authenticator.createIdentity(user.getId());
            }
            catch (Throwable t) {
                throw new ApiException("Failed to retrieve user identity", t);
            }
            if (identity == null) {
                throw new EntityNotFoundException("User not found");
            }
            try {
                this.identityRegistry.register(identity);
            }
            catch (Throwable t) {
                throw new ApiException("Failed to register identity", t);
            }
        }
        try {
            for (Membership membership : permission.getMemberships()) {
                if (!this.acl.hasPermission(identity, membership.toString())) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw new ApiException("Failed to check permissions", t);
        }
    }

    public OAuthProvider getOAuthProvider(String oauthProviderKey) {
        return this.oauthProviderAccessor.getOAuthProvider(oauthProviderKey);
    }

    private static <T> void filter(List<T> list, Filter<T> filter) {
        if (filter == null) {
            return;
        }
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (filter.accept(iterator.next())) continue;
            iterator.remove();
        }
    }

    private static <T> List<T> paginate(List<T> list, Pagination pagination) {
        if (pagination == null) {
            return list;
        }
        if (pagination.getOffset() >= list.size()) {
            return Collections.emptyList();
        }
        if (pagination.getOffset() + pagination.getLimit() > list.size()) {
            return new ArrayList<T>(list.subList(pagination.getOffset(), list.size()));
        }
        return new ArrayList<T>(list.subList(pagination.getOffset(), pagination.getOffset() + pagination.getLimit()));
    }

    private static List<Site> fromList(List<PortalConfig> internalSites) {
        ArrayList<Site> sites = new ArrayList<Site>(internalSites.size());
        for (PortalConfig internalSite : internalSites) {
            if (internalSite == null) continue;
            sites.add(new SiteImpl(internalSite));
        }
        return sites;
    }

    private PortalConfig[] loadSites(boolean includeAllSites, ListAccess<PortalConfig> access, int size, int offset, int limit) throws Exception {
        PortalConfig[] loaded;
        PortalConfig[] sites = new PortalConfig[Math.min(limit + offset, size)];
        int loadIndex = 0;
        int loadLength = sites.length;
        int length = 0;
        for (int index = 0; index < sites.length && loadIndex < size; index += loaded.length) {
            loaded = this.load(access, loadIndex, loadLength, includeAllSites);
            int copyLength = Math.min(loaded.length, sites.length - index);
            System.arraycopy(loaded, 0, sites, index, copyLength);
            if ((length += copyLength) == sites.length) break;
            if ((loadLength += limit) + (loadIndex += sites.length) <= size) continue;
            loadLength = size - loadIndex;
        }
        return sites;
    }

    private PortalConfig[] load(ListAccess<PortalConfig> access, int start, int end, boolean includeAllSites) throws Exception {
        PortalConfig[] loaded = (PortalConfig[])access.load(start, end);
        ArrayList<PortalConfig> list = new ArrayList<PortalConfig>(loaded.length);
        for (PortalConfig pc : loaded) {
            if (pc == null) continue;
            NavigationContext ctx = null;
            if (!includeAllSites) {
                try {
                    ctx = this.navigationService.loadNavigation(new SiteKey(pc.getType(), pc.getName()));
                }
                catch (Throwable t) {
                    throw new ApiException("Failed to find sites", t);
                }
            }
            if (!includeAllSites && ctx == null) continue;
            list.add(pc);
        }
        return list.toArray(new PortalConfig[list.size()]);
    }
}

