/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.xml.stax.navigator;

import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.common.xml.stax.navigator.Exceptions;
import org.gatein.common.xml.stax.navigator.builder.StaxNavBuilder;
import org.gatein.common.xml.stax.navigator.builder.StaxNavBuilderImpl;
import org.staxnav.EnumElement;
import org.staxnav.Naming;
import org.staxnav.StaxNavException;
import org.staxnav.StaxNavigator;
import org.staxnav.ValueType;

public class StaxNavUtils {
    public static <N> StaxNavigator<N> createNavigator(Naming<N> naming, InputStream in) throws StaxNavException {
        return StaxNavUtils.buildDefaultNavigator().withInputStream(in).build(naming);
    }

    public static StaxNavigator<String> createNavigator(InputStream in) throws StaxNavException {
        return StaxNavUtils.createNavigator(new Naming.Local(), in);
    }

    public static StaxNavigator<QName> createQualifiedNavigator(InputStream in) throws StaxNavException {
        return StaxNavUtils.createNavigator(new Naming.Qualified(), in);
    }

    public static <E extends Enum<E>> StaxNavigator<E> createNavigator(Class<E> enumeratedClass, E noSuchElement, InputStream in) throws StaxNavException {
        Object naming = EnumElement.class.isAssignableFrom(enumeratedClass) ? new Naming.Enumerated.Mapped(enumeratedClass, noSuchElement) : new Naming.Enumerated.Simple(enumeratedClass, noSuchElement);
        return StaxNavUtils.createNavigator(naming, in);
    }

    public static <N> StaxNavigator<N> createNavigator(Naming<N> naming, Reader reader) throws StaxNavException {
        return StaxNavUtils.buildDefaultNavigator().withReader(reader).build(naming);
    }

    public static StaxNavigator<String> createNavigator(Reader reader) throws StaxNavException {
        return StaxNavUtils.createNavigator(new Naming.Local(), reader);
    }

    public static StaxNavigator<QName> createQualifiedNavigator(Reader reader) throws StaxNavException {
        return StaxNavUtils.createNavigator(new Naming.Qualified(), reader);
    }

    public static <E extends Enum<E>> StaxNavigator<E> createNavigator(Class<E> enumeratedClass, E noSuchElement, Reader reader) throws StaxNavException {
        Object naming = EnumElement.class.isAssignableFrom(enumeratedClass) ? new Naming.Enumerated.Mapped(enumeratedClass, noSuchElement) : new Naming.Enumerated.Simple(enumeratedClass, noSuchElement);
        return StaxNavUtils.createNavigator(naming, reader);
    }

    public static <N> void requiresChild(StaxNavigator<N> navigator, N element) {
        if (navigator.child() != element) {
            throw Exceptions.expectedElement(navigator, element);
        }
    }

    public static <N> void requiresSibling(StaxNavigator<N> navigator, N element) {
        if (!navigator.sibling(element)) {
            throw Exceptions.expectedElement(navigator, element);
        }
    }

    public static String getRequiredAttribute(StaxNavigator navigator, String attributeName) throws StaxNavException {
        String value = navigator.getAttribute(attributeName);
        if (value == null) {
            throw new StaxNavException(navigator.getLocation(), "Attribute '" + attributeName + "' is required for element '" + navigator.getLocalName() + "'");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <N> String getContent(StaxNavigator<N> navigator, boolean trim) {
        boolean before = navigator.getTrimContent();
        try {
            navigator.setTrimContent(trim);
            String string = navigator.getContent();
            return string;
        }
        finally {
            navigator.setTrimContent(before);
        }
    }

    public static <N> String getRequiredContent(StaxNavigator<N> navigator, boolean trim) {
        String content = StaxNavUtils.getContent(navigator, trim);
        if (content == null || content.length() == 0) {
            throw Exceptions.contentRequired(navigator);
        }
        return content;
    }

    public static <N, V> V parseContent(StaxNavigator<N> navigator, ValueType<V> valueType, V defaultValue) {
        String content = StaxNavUtils.getContent(navigator, true);
        if (content != null && content.length() != 0) {
            return (V)navigator.parseContent(valueType);
        }
        return defaultValue;
    }

    public static <N, V> V parseRequiredContent(StaxNavigator<N> navigator, ValueType<V> valueType) {
        V value = StaxNavUtils.parseContent(navigator, valueType, null);
        if (value == null) {
            throw Exceptions.contentRequired(navigator);
        }
        return value;
    }

    public static <N> Set<N> forNames(N ... names) {
        return new HashSet<N>(Arrays.asList(names));
    }

    private static StaxNavBuilder buildDefaultNavigator() {
        return new StaxNavBuilderImpl();
    }

    private StaxNavUtils() {
    }
}

