/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.xml;

import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exoplatform.commons.xml.DocumentSource;
import org.exoplatform.commons.xml.ResourceEntityResolver;
import org.exoplatform.commons.xml.ValidationReporter;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLValidator {
    private final String[] schemas;
    private final ResourceEntityResolver resolver;
    private DocumentBuilderFactory documentBuilderFactory;
    private final Logger log = LoggerFactory.getLogger(XMLValidator.class);

    public XMLValidator(Class clazz, String systemId, String resourcePath) {
        this.schemas = new String[]{systemId};
        this.resolver = new ResourceEntityResolver(clazz, systemId, resourcePath);
        this.createDocumentBuilderFactory();
    }

    public XMLValidator(Class clazz, Map<String, String> systemIdToResourcePath) {
        this.schemas = systemIdToResourcePath.keySet().toArray(new String[0]);
        this.resolver = new ResourceEntityResolver(clazz, systemIdToResourcePath);
        this.createDocumentBuilderFactory();
    }

    private void createDocumentBuilderFactory() {
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", this.schemas);
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setValidating(true);
    }

    public Document validate(DocumentSource source) throws NullPointerException, IOException {
        if (source == null) {
            throw new NullPointerException();
        }
        try {
            DocumentBuilder builder = this.documentBuilderFactory.newDocumentBuilder();
            ValidationReporter reporter = new ValidationReporter(this.log, source.getIdentifier());
            builder.setErrorHandler(reporter);
            builder.setEntityResolver(this.resolver);
            return builder.parse(source.getStream());
        }
        catch (ParserConfigurationException e) {
            this.log.error((Object)"Got a parser configuration exception when doing XSD validation");
            return null;
        }
        catch (SAXException e) {
            this.log.error((Object)"Got a sax exception when doing XSD validation");
            return null;
        }
    }
}

