/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.idm.AbstractDAOImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.UserDAOImpl;
import org.exoplatform.services.organization.impl.UserProfileImpl;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.User;
import org.picketlink.idm.impl.api.SimpleAttribute;

public class UserProfileDAOImpl
extends AbstractDAOImpl
implements UserProfileHandler {
    private static UserProfile NOT_FOUND = new UserProfileImpl();
    private List<UserProfileEventListener> listeners_ = new ArrayList<UserProfileEventListener>(3);

    public UserProfileDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService service) {
        super(orgService, service);
    }

    public void addUserProfileEventListener(UserProfileEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners_.add(listener);
    }

    public void removeUserProfileEventListener(UserProfileEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners_.remove(listener);
    }

    public final UserProfile createUserProfileInstance() {
        return new UserProfileImpl();
    }

    public UserProfile createUserProfileInstance(String userName) {
        return new UserProfileImpl(userName);
    }

    public void saveUserProfile(UserProfile profile, boolean broadcast) throws Exception {
        boolean isNew = true;
        if (broadcast) {
            UserProfile found = this.getProfile(profile.getUserName());
            boolean bl = isNew = found == null;
        }
        if (broadcast) {
            this.preSave(profile, isNew);
        }
        this.setProfile(profile.getUserName(), profile);
        if (broadcast) {
            this.postSave(profile, isNew);
        }
    }

    public UserProfile removeUserProfile(String userName, boolean broadcast) throws Exception {
        UserProfile profile = this.getProfile(userName);
        if (profile != null) {
            try {
                if (broadcast) {
                    this.preDelete(profile);
                }
                this.removeProfile(userName, profile);
                if (broadcast) {
                    this.postDelete(profile);
                }
                return profile;
            }
            catch (Exception exp) {
                this.handleException("Exception occured when removing user profile", exp);
                return null;
            }
        }
        return null;
    }

    public UserProfile findUserProfileByName(String userName) throws Exception {
        User foundUser = null;
        try {
            foundUser = this.getIdentitySession().getPersistenceManager().findUser(userName);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (foundUser == null) {
            return null;
        }
        UserProfile up = this.getProfile(userName);
        if (up == null) {
            up = NOT_FOUND;
        }
        if (up == NOT_FOUND) {
            UserProfileImpl profile = new UserProfileImpl();
            profile.setUserName(userName);
            return profile;
        }
        return up;
    }

    public Collection findUserProfiles() throws Exception {
        return null;
    }

    private void preSave(UserProfile profile, boolean isNew) throws Exception {
        for (UserProfileEventListener listener : this.listeners_) {
            listener.preSave(profile, isNew);
        }
    }

    private void postSave(UserProfile profile, boolean isNew) throws Exception {
        for (UserProfileEventListener listener : this.listeners_) {
            listener.postSave(profile, isNew);
        }
    }

    private void preDelete(UserProfile profile) throws Exception {
        for (UserProfileEventListener listener : this.listeners_) {
            listener.preDelete(profile);
        }
    }

    private void postDelete(UserProfile profile) throws Exception {
        for (UserProfileEventListener listener : this.listeners_) {
            listener.postDelete(profile);
        }
    }

    public UserProfile getProfile(String userName) {
        User u = null;
        try {
            u = this.getIdentitySession().getPersistenceManager().findUser(userName);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (u == null) {
            return null;
        }
        Map attrs = new HashMap();
        try {
            attrs = this.getIdentitySession().getAttributesManager().getAttributes(userName);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        HashMap<String, String> filteredAttrs = new HashMap<String, String>();
        for (String key : attrs.keySet()) {
            if (UserDAOImpl.USER_NON_PROFILE_KEYS.contains(key)) continue;
            Object value = ((Attribute)attrs.get(key)).getValue();
            if (value != null) {
                filteredAttrs.put(key, value.toString());
                continue;
            }
            filteredAttrs.put(key, null);
        }
        if (filteredAttrs.isEmpty()) {
            return null;
        }
        UserProfileImpl profile = new UserProfileImpl(userName, filteredAttrs);
        return profile;
    }

    public void setProfile(String userName, UserProfile profile) {
        Map profileAttrs = profile.getUserInfoMap();
        HashSet<SimpleAttribute> attrs = new HashSet<SimpleAttribute>();
        for (Map.Entry entry : profileAttrs.entrySet()) {
            String attrValue = (String)entry.getValue();
            if ("".equals(attrValue)) {
                attrValue = null;
            }
            attrs.add(new SimpleAttribute((String)entry.getKey(), (Object)attrValue));
        }
        Attribute[] attrArray = new Attribute[attrs.size()];
        attrArray = attrs.toArray(attrArray);
        try {
            this.getIdentitySession().getAttributesManager().updateAttributes(userName, attrArray);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
    }

    public void removeProfile(String userName, UserProfile profile) {
        Map profileAttrs = profile.getUserInfoMap();
        String[] attrKeys = new String[profileAttrs.keySet().size()];
        attrKeys = profileAttrs.keySet().toArray(attrKeys);
        try {
            this.getIdentitySession().getAttributesManager().removeAttributes(userName, attrKeys);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
    }
}

