/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources;

import org.exoplatform.services.resources.AbstractResourceBundleTest;
import org.exoplatform.services.resources.ExoResourceBundle;
import org.exoplatform.services.resources.ResourceBundleData;

public class TestExoResourceBundle
extends AbstractResourceBundleTest {
    public void testConstructor() {
        ExoResourceBundle bundle = new ExoResourceBundle("key1=value");
        TestExoResourceBundle.assertEquals((int)1, (int)bundle.getContents().length);
        TestExoResourceBundle.assertEquals((String)"value", (String)bundle.getString("key1"));
        bundle = new ExoResourceBundle("key1=value\nkey2=value");
        TestExoResourceBundle.assertEquals((int)2, (int)bundle.getContents().length);
        TestExoResourceBundle.assertEquals((String)"value", (String)bundle.getString("key1"));
        TestExoResourceBundle.assertEquals((String)"value", (String)bundle.getString("key2"));
        bundle = new ExoResourceBundle("key1=value\r\nkey2=value");
        TestExoResourceBundle.assertEquals((int)2, (int)bundle.getContents().length);
        TestExoResourceBundle.assertEquals((String)"value", (String)bundle.getString("key1"));
        TestExoResourceBundle.assertEquals((String)"value", (String)bundle.getString("key2"));
        bundle = new ExoResourceBundle("#comment\r\nkey2=value");
        TestExoResourceBundle.assertEquals((int)1, (int)bundle.getContents().length);
        TestExoResourceBundle.assertEquals((String)"value", (String)bundle.getString("key2"));
        bundle = new ExoResourceBundle("  #comment\r\nkey2=value");
        TestExoResourceBundle.assertEquals((int)1, (int)bundle.getContents().length);
        TestExoResourceBundle.assertEquals((String)"value", (String)bundle.getString("key2"));
        bundle = new ExoResourceBundle("  bad entry\r\nkey2=value");
        TestExoResourceBundle.assertEquals((int)1, (int)bundle.getContents().length);
        TestExoResourceBundle.assertEquals((String)"value", (String)bundle.getString("key2"));
        bundle = new ExoResourceBundle("#key1 =value\r\nkey2=value");
        TestExoResourceBundle.assertEquals((int)1, (int)bundle.getContents().length);
        TestExoResourceBundle.assertEquals((String)"value", (String)bundle.getString("key2"));
        bundle = new ExoResourceBundle(" key1 =value\r\n key2 =value");
        TestExoResourceBundle.assertEquals((int)2, (int)bundle.getContents().length);
        TestExoResourceBundle.assertEquals((String)"value", (String)bundle.getString(" key1 "));
        TestExoResourceBundle.assertEquals((String)"value", (String)bundle.getString(" key2 "));
    }

    public void testUnicode2Char() {
        for (int i = 0; i < 65536; ++i) {
            String value = Integer.toHexString(i);
            while (value.length() < 4) {
                value = "0" + value;
            }
            TestExoResourceBundle.assertEquals((char)((char)i), (char)ResourceBundleData.unicode2Char((String)("\\u" + value)));
        }
    }

    public void testConvert() {
        TestExoResourceBundle.assertEquals((String)"Normal Value", (String)ResourceBundleData.convert((String)"Normal Value"));
        TestExoResourceBundle.assertEquals((String)"\u00e9\u00e7\u00e0\u00f9\u0194\u0bf5", (String)ResourceBundleData.convert((String)"\\u00E9\\u00E7\\u00E0\\u00F9\\u0194\\u0BF5"));
        TestExoResourceBundle.assertEquals((String)"before \u00e9\u00e7\u00e0\u00f9\u0194\u0bf5", (String)ResourceBundleData.convert((String)"before \\u00E9\\u00E7\\u00E0\\u00F9\\u0194\\u0BF5"));
        TestExoResourceBundle.assertEquals((String)"\u00e9\u00e7\u00e0\u00f9\u0194\u0bf5 after", (String)ResourceBundleData.convert((String)"\\u00E9\\u00E7\\u00E0\\u00F9\\u0194\\u0BF5 after"));
        TestExoResourceBundle.assertEquals((String)"before \u00e9\u00e7\u00e0 between \u00f9\u0194\u0bf5 after", (String)ResourceBundleData.convert((String)"before \\u00E9\\u00E7\\u00E0 between \\u00F9\\u0194\\u0BF5 after"));
    }
}

