/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application;

import java.io.Serializable;
import java.util.Arrays;
import org.exoplatform.web.application.AbstractApplicationMessage;

public class ApplicationMessage
extends AbstractApplicationMessage
implements Serializable {
    private final String messageKey_;
    private final Object[] messageArgs_;

    public ApplicationMessage(String key, Object[] args) {
        this.messageKey_ = key;
        this.messageArgs_ = args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationMessage that = (ApplicationMessage)o;
        if (!Arrays.equals(this.messageArgs_, that.messageArgs_)) {
            return false;
        }
        return this.messageKey_.equals(that.messageKey_);
    }

    public int hashCode() {
        int result = this.messageKey_.hashCode();
        result = 31 * result + (this.messageArgs_ != null ? Arrays.hashCode(this.messageArgs_) : 0);
        return result;
    }

    public ApplicationMessage(String key, Object[] args, int type) {
        this.messageKey_ = key;
        this.messageArgs_ = args;
        this.setType(type);
    }

    @Override
    public String getMessageKey() {
        return this.messageKey_;
    }

    @Override
    public String getMessage() {
        String msg = this.resolveMessage(this.messageKey_);
        if (msg != null && this.messageArgs_ != null) {
            for (int i = 0; i < this.messageArgs_.length; ++i) {
                Object messageArg = this.messageArgs_[i];
                if (messageArg == null) continue;
                String arg = messageArg.toString();
                if (this.isArgsLocalized()) {
                    arg = this.resolveMessage(arg);
                }
                msg = msg.replace("{" + i + "}", arg);
            }
        }
        return msg;
    }
}

