/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.test;

import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.User;
import org.gatein.security.oauth.facebook.FacebookAccessTokenContext;
import org.gatein.security.oauth.linkedin.LinkedInPrincipalProcessor;
import org.gatein.security.oauth.linkedin.LinkedinAccessTokenContext;
import org.gatein.security.oauth.principal.DefaultPrincipalProcessor;
import org.gatein.security.oauth.spi.OAuthPrincipal;
import org.gatein.security.oauth.spi.OAuthPrincipalProcessor;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.spi.OAuthProviderTypeRegistry;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.web.oauth-configuration.xml")})
public class TestOAuthPrincipalProcessor
extends AbstractKernelTest {
    private OAuthProviderTypeRegistry oAuthProviderTypeRegistry;

    protected void setUp() throws Exception {
        PortalContainer portalContainer = PortalContainer.getInstance();
        this.oAuthProviderTypeRegistry = (OAuthProviderTypeRegistry)portalContainer.getComponentInstanceOfType(OAuthProviderTypeRegistry.class);
        this.begin();
    }

    protected void tearDown() throws Exception {
        this.end();
    }

    public void testOAuthPrincipalRegistration() {
        OAuthProviderType oAuthProvider = this.oAuthProviderTypeRegistry.getOAuthProvider("FACEBOOK", FacebookAccessTokenContext.class);
        OAuthPrincipalProcessor oauthPrincipalProcessor = oAuthProvider.getOauthPrincipalProcessor();
        TestOAuthPrincipalProcessor.assertNotNull((Object)oauthPrincipalProcessor);
        TestOAuthPrincipalProcessor.assertEquals(DefaultPrincipalProcessor.class, oauthPrincipalProcessor.getClass());
        oAuthProvider = this.oAuthProviderTypeRegistry.getOAuthProvider("LINKEDIN", LinkedinAccessTokenContext.class);
        oauthPrincipalProcessor = oAuthProvider.getOauthPrincipalProcessor();
        TestOAuthPrincipalProcessor.assertNotNull((Object)oauthPrincipalProcessor);
        TestOAuthPrincipalProcessor.assertEquals(LinkedInPrincipalProcessor.class, oauthPrincipalProcessor.getClass());
    }

    public void testDefaultGenerateGateInUser() {
        OAuthProviderType providerType = new OAuthProviderType("OAUTH", true, "", null, null, "", "");
        OAuthPrincipal principal = new OAuthPrincipal("username", "firstName", "lastName", "displayName", "email@localhost.com", null, providerType);
        DefaultPrincipalProcessor principalProcessor = new DefaultPrincipalProcessor();
        User user = principalProcessor.convertToGateInUser(principal);
        TestOAuthPrincipalProcessor.assertNotNull((Object)user);
        TestOAuthPrincipalProcessor.assertEquals((String)"username", (String)user.getUserName());
        TestOAuthPrincipalProcessor.assertEquals((String)"email@localhost.com", (String)user.getEmail());
        TestOAuthPrincipalProcessor.assertEquals((String)"firstName", (String)user.getFirstName());
        TestOAuthPrincipalProcessor.assertEquals((String)"lastName", (String)user.getLastName());
        TestOAuthPrincipalProcessor.assertEquals((String)"displayName", (String)user.getDisplayName());
    }

    public void testLinkedInGenerateGateInUser() {
        OAuthProviderType providerType = new OAuthProviderType("LINKEDIN", true, "", null, null, "", "");
        OAuthPrincipal principal = new OAuthPrincipal("randomString", "firstName", "lastName", "displayName", "linkedin_user@localhost.com", null, providerType);
        LinkedInPrincipalProcessor principalProcessor = new LinkedInPrincipalProcessor();
        User user = principalProcessor.convertToGateInUser(principal);
        TestOAuthPrincipalProcessor.assertNotNull((Object)user);
        TestOAuthPrincipalProcessor.assertEquals((String)"linkedin_user", (String)user.getUserName());
        TestOAuthPrincipalProcessor.assertEquals((String)"linkedin_user@localhost.com", (String)user.getEmail());
        TestOAuthPrincipalProcessor.assertEquals((String)"firstName", (String)user.getFirstName());
        TestOAuthPrincipalProcessor.assertEquals((String)"lastName", (String)user.getLastName());
        TestOAuthPrincipalProcessor.assertEquals((String)"displayName", (String)user.getDisplayName());
    }
}

