/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.controller.resource.script;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.FetchMode;
import org.gatein.portal.controller.resource.script.ScriptFetch;
import org.gatein.portal.controller.resource.script.ScriptGroup;
import org.gatein.portal.controller.resource.script.ScriptResource;

public class ScriptGraph {
    final EnumMap<ResourceScope, Map<String, ScriptResource>> resources;
    final Map<String, ScriptGroup> loadGroups;
    private static final Log log = ExoLogger.getExoLogger(ScriptGraph.class);

    public ScriptGraph() {
        EnumMap resources = new EnumMap(ResourceScope.class);
        for (ResourceScope scope : ResourceScope.values()) {
            resources.put(scope, new HashMap());
        }
        this.resources = resources;
        this.loadGroups = new HashMap<String, ScriptGroup>();
    }

    public Map<ScriptResource, FetchMode> resolve(Map<ResourceId, FetchMode> pairs) {
        HashMap<ResourceId, ScriptFetch> determined = new HashMap<ResourceId, ScriptFetch>();
        for (Map.Entry<ResourceId, FetchMode> pair : pairs.entrySet()) {
            this.traverse(determined, pair.getKey(), pair.getValue());
        }
        LinkedHashMap<ScriptResource, FetchMode> result = new LinkedHashMap<ScriptResource, FetchMode>();
        LinkedList all = new LinkedList(determined.values());
        while (all.size() > 0) {
            ScriptFetch next = null;
            Iterator i = all.iterator();
            while (i.hasNext()) {
                ScriptFetch fetch = (ScriptFetch)i.next();
                if (fetch.dependencies.size() != 0) continue;
                i.remove();
                next = fetch;
                for (ScriptFetch dependent : fetch.dependsOnMe) {
                    dependent.dependencies.remove(fetch);
                }
            }
            if (next == null) {
                throw new AssertionError((Object)"This is a bug");
            }
            result.put(next.resource, next.mode);
        }
        return result;
    }

    private ScriptFetch traverse(Map<ResourceId, ScriptFetch> map, ResourceId id, FetchMode mode) {
        ScriptResource resource = this.getResource(id);
        if (resource != null) {
            if (mode != null && !resource.fetchMode.equals((Object)mode)) {
                return null;
            }
            mode = resource.fetchMode;
            ScriptFetch fetch = map.get(id);
            if (fetch == null) {
                fetch = new ScriptFetch(resource, mode);
                if (!resource.isEmpty() || ResourceScope.SHARED.equals((Object)resource.getId().getScope())) {
                    map.put(id, fetch);
                }
                if (FetchMode.IMMEDIATE.equals((Object)mode) || resource.isEmpty()) {
                    for (ResourceId dependencyId : resource.dependencies.keySet()) {
                        ScriptFetch dependencyFetch = this.traverse(map, dependencyId, mode);
                        if (dependencyFetch == null) continue;
                        dependencyFetch.dependsOnMe.add(fetch);
                        fetch.dependencies.add(dependencyFetch);
                    }
                }
            }
            return fetch;
        }
        return null;
    }

    public ScriptResource getResource(ResourceId id) {
        return this.getResource(id.getScope(), id.getName());
    }

    public ScriptResource getResource(ResourceScope scope, String name) {
        return this.resources.get((Object)scope).get(name);
    }

    public Collection<ScriptResource> getResources(ResourceScope scope) {
        return this.resources.get((Object)scope).values();
    }

    public ScriptResource addResource(ResourceId id) {
        return this.addResource(id, FetchMode.IMMEDIATE);
    }

    public ScriptResource addResource(ResourceId id, FetchMode fetchMode) throws NullPointerException {
        return this.addResource(id, fetchMode, null, null, null);
    }

    public ScriptResource addResource(ResourceId id, FetchMode fetchMode, String alias, String groupName, String contextPath) throws NullPointerException {
        String name;
        Map<String, ScriptResource> map;
        ScriptResource resource;
        if (id == null) {
            throw new NullPointerException("No null resource accepted");
        }
        if (fetchMode == null) {
            throw new NullPointerException("No null fetch mode accepted");
        }
        if (ResourceScope.SHARED.equals((Object)id.getScope())) {
            for (Map<String, ScriptResource> mp : this.resources.values()) {
                for (ScriptResource rs : mp.values()) {
                    if (!rs.getDependencies().contains(id) || rs.getFetchMode().equals((Object)fetchMode)) continue;
                    throw new IllegalStateException("ScriptResource " + rs.getId() + " can't depend on " + id + ". They have difference fetchMode");
                }
            }
            if (JavascriptConfigService.RESERVED_MODULE.contains(id.getName())) {
                throw new IllegalStateException("Can't not add " + id + ". The name " + id.getName() + " is reserved name");
            }
        }
        if ((resource = (map = this.resources.get((Object)id.getScope())).get(name = id.getName())) == null) {
            ScriptGroup group = null;
            if (groupName != null && contextPath != null) {
                group = this.loadGroups.get(groupName);
                if (group == null) {
                    ResourceId grpId = new ResourceId(ResourceScope.GROUP, groupName);
                    group = new ScriptGroup(this, grpId, contextPath);
                    this.loadGroups.put(groupName, group);
                    group.addDependency(id);
                } else if (!contextPath.equals(group.contextPath)) {
                    log.warn("Can't add cross context resource {} to {} group", new Object[]{id, groupName});
                    group = null;
                } else {
                    group.addDependency(id);
                }
            }
            resource = new ScriptResource(this, id, fetchMode, alias, group);
            map.put(name, resource);
        } else if (!id.getScope().equals((Object)ResourceScope.SHARED) || !"merged".equals(name)) {
            throw new IllegalStateException("Duplicate ResourceId : " + id + ", later resource definition will be ignored");
        }
        return resource;
    }

    public ScriptResource removeResource(ResourceId id) {
        ScriptResource removed = this.resources.get((Object)id.getScope()).remove(id.getName());
        if (removed != null) {
            removed.graph = null;
        }
        return removed;
    }

    public ScriptGroup getLoadGroup(String groupName) {
        return this.loadGroups.get(groupName);
    }
}

