/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource.compressor;

import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.portal.resource.compressor.ResourceCompressorPlugin;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

@Managed
@ManagedDescription(value="A resource compressor plugin")
@NameTemplate(value={@Property(key="service", value="resource"), @Property(key="compressor", value="{Name}")})
public abstract class BaseResourceCompressorPlugin
extends BaseComponentPlugin
implements ResourceCompressorPlugin {
    private int priority;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public BaseResourceCompressorPlugin(InitParams params) {
        ValueParam priorityParam = params.getValueParam("plugin.priority");
        try {
            this.priority = Integer.parseInt(priorityParam.getValue());
        }
        catch (NumberFormatException NBFEx) {
            this.priority = -1;
        }
    }

    @Override
    @Managed
    @ManagedDescription(value="The plugin priority")
    public int getPriority() {
        return this.priority;
    }

    @Managed
    @ManagedDescription(value="The plugin type")
    public String getType() {
        return this.getResourceType().name();
    }
}

