/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.security.jboss;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.exoplatform.container.ExoContainer;
import org.jboss.logging.Logger;

public class PortalClusteredSSOSupportValve
extends ValveBase
implements Lifecycle {
    private static final Logger log = Logger.getLogger(PortalClusteredSSOSupportValve.class);
    private final LifecycleSupport support = new LifecycleSupport((Lifecycle)this);
    private SingleSignOn sso = null;
    private boolean requireClusterProfile = true;

    public void setRequireClusterProfile(boolean requireClusterProfile) {
        this.requireClusterProfile = requireClusterProfile;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.sso != null) {
            Realm realm;
            Container parent;
            Session session = request.getSessionInternal();
            String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
            if (ssoId != null && request.getUserPrincipal() == null && this.sso != null && (parent = this.getContainer()) != null && (realm = parent.getRealm()) != null && this.sso.reauthenticate(ssoId, realm, request)) {
                this.sso.associate(ssoId, session);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Reauthenticated cached principal '" + request.getUserPrincipal().getName() + "' with auth type '" + request.getAuthType() + "'"));
                }
            }
        }
        this.getNext().invoke(request, response);
    }

    private SingleSignOn findSSOValve() {
        if (this.requireClusterProfile && !ExoContainer.getProfiles().contains("cluster")) {
            return null;
        }
        for (Container parent = this.container.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Pipeline)) continue;
            Valve[] valves = ((Pipeline)parent).getValves();
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                SingleSignOn sso = (SingleSignOn)valves[i];
                log.debug((Object)("Found SingleSignOn Valve at " + sso));
                return sso;
            }
        }
        log.debug((Object)"No SingleSignOn Valve is present");
        return null;
    }

    public void start() throws LifecycleException {
        this.sso = this.findSSOValve();
        this.support.fireLifecycleEvent("start", (Object)this);
    }

    public void stop() throws LifecycleException {
        this.support.fireLifecycleEvent("stop", (Object)this);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.support.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.support.removeLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.support.findLifecycleListeners();
    }
}

