/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security;

import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.security.AbstractTokenServiceTest;
import org.exoplatform.web.security.GateInToken;
import org.exoplatform.web.security.security.CookieTokenService;
import org.gatein.wci.security.Credentials;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/tokenservice-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.test.jcr-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/jcr-configuration.xml")})
public class TestCookieService
extends AbstractTokenServiceTest<CookieTokenService> {
    protected void setUp() throws Exception {
        PortalContainer container = this.getContainer();
        this.service = (CookieTokenService)container.getComponentInstanceOfType(CookieTokenService.class);
        Thread.sleep(1000L);
    }

    @Override
    public void testGetToken() throws Exception {
        String tokenId = ((CookieTokenService)this.service).createToken(new Credentials("root", "gtn"));
        TestCookieService.assertEquals((long)((CookieTokenService)this.service).getValidityTime(), (long)2L);
        GateInToken token = ((CookieTokenService)this.service).getToken(tokenId);
        TestCookieService.assertEquals((String)token.getPayload().getUsername(), (String)"root");
        TestCookieService.assertEquals((String)token.getPayload().getPassword(), (String)"gtn");
        ((CookieTokenService)this.service).deleteToken(tokenId);
    }

    @Override
    public void testGetAllToken() throws Exception {
        String token1 = ((CookieTokenService)this.service).createToken(new Credentials("root", "gtn"));
        String token2 = ((CookieTokenService)this.service).createToken(new Credentials("root1", "gtn1"));
        String[] tokens = ((CookieTokenService)this.service).getAllTokens();
        TestCookieService.assertEquals((int)tokens.length, (int)2);
        TestCookieService.assertSame((Object)token1, (Object)tokens[0]);
        TestCookieService.assertSame((Object)token2, (Object)tokens[1]);
        ((CookieTokenService)this.service).deleteToken(token1);
        ((CookieTokenService)this.service).deleteToken(token2);
    }

    @Override
    public void testSize() throws Exception {
        String token = ((CookieTokenService)this.service).createToken(new Credentials("root", "gtn"));
        TestCookieService.assertEquals((long)((CookieTokenService)this.service).size(), (long)1L);
        ((CookieTokenService)this.service).deleteToken(token);
    }

    @Override
    public void testDeleteToken() throws Exception {
        String tokenId = ((CookieTokenService)this.service).createToken(new Credentials("root", "gtn"));
        TestCookieService.assertNotSame((Object)((CookieTokenService)this.service).getToken(tokenId), (Object)((CookieTokenService)this.service).deleteToken(tokenId));
        TestCookieService.assertNull((Object)((CookieTokenService)this.service).getToken(tokenId));
        TestCookieService.assertEquals((long)((CookieTokenService)this.service).size(), (long)0L);
        ((CookieTokenService)this.service).deleteToken(tokenId);
    }
}

