/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security;

import java.io.File;
import java.net.URL;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.security.SimpleGeneratorCookieTokenService;
import org.gatein.wci.security.Credentials;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/tokenservice-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.test.jcr-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/jcr-configuration.xml")})
public class TestSimpleGeneratorService
extends AbstractKernelTest {
    private SimpleGeneratorCookieTokenService service;

    protected void beforeRunBare() {
        String foundGateInConfDir = PropertyManager.getProperty((String)"gatein.conf.dir");
        if (foundGateInConfDir == null || foundGateInConfDir.length() == 0) {
            URL tokenserviceConfUrl = Thread.currentThread().getContextClassLoader().getResource("conf/tokenservice-configuration.xml");
            File confDir = new File(tokenserviceConfUrl.getPath()).getParentFile();
            PropertyManager.setProperty((String)"gatein.conf.dir", (String)confDir.getAbsolutePath());
        }
        super.beforeRunBare();
    }

    protected void setUp() throws Exception {
        PortalContainer container = this.getContainer();
        this.service = (SimpleGeneratorCookieTokenService)((Object)container.getComponentInstanceOfType(SimpleGeneratorCookieTokenService.class));
        Thread.sleep(1000L);
    }

    public void testDuplicatedTokenGeneration() throws Exception {
        String token1 = this.service.createToken(new Credentials("root1", "gtn1"));
        TestSimpleGeneratorService.assertEquals((String)"random0.rememberme0", (String)token1);
        TestSimpleGeneratorService.assertEquals((int)this.service.getCounter(), (int)1);
        String token2 = this.service.createToken(new Credentials("root2", "gtn2"));
        TestSimpleGeneratorService.assertEquals((String)"random1.rememberme1", (String)token2);
        TestSimpleGeneratorService.assertEquals((int)this.service.getCounter(), (int)2);
        String token3 = this.service.createToken(new Credentials("-root3", "gtn3"));
        TestSimpleGeneratorService.assertEquals((String)"random2.rememberme2", (String)token3);
        TestSimpleGeneratorService.assertEquals((int)this.service.getCounter(), (int)4);
        TestSimpleGeneratorService.assertEquals((String)"root1", (String)this.service.getToken(token1).getPayload().getUsername());
        TestSimpleGeneratorService.assertEquals((String)"root2", (String)this.service.getToken(token2).getPayload().getUsername());
        TestSimpleGeneratorService.assertEquals((String)"-root3", (String)this.service.getToken(token3).getPayload().getUsername());
    }
}

