/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.upload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.services.html.refs.RefsDecoder;
import org.exoplatform.upload.ParameterParser;
import org.exoplatform.upload.UploadResource;

class RequestStreamReader {
    private static final byte LF = 10;
    private static final byte DASH = 45;
    private static final byte CR = 13;
    private static final byte[] HEADER_SEPARATOR = new byte[]{13, 10, 13, 10};
    private static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
    private static final String CONTENT_DISPOSITION = "Content-disposition";
    private static final String FORM_DATA = "form-data";
    private static final int HEADER_PART_SIZE_MAX = 10240;
    private static final String ATTACHMENT = "attachment";
    private static final int DEFAULT_BUFSIZE = 4096;
    static final String CONTENT_TYPE = "content-type";
    private int head;
    private int tail;
    private int bufSize;
    private byte[] buffer;
    private UploadResource upResource_;
    private RefsDecoder refsDecoder_;

    RequestStreamReader(UploadResource upResource) {
        this.upResource_ = upResource;
        this.head = 0;
        this.tail = 0;
        this.bufSize = 4096;
        this.buffer = new byte[this.bufSize];
        this.refsDecoder_ = new RefsDecoder();
    }

    void readBodyData(HttpServletRequest request, OutputStream output) throws IOException {
        this.readBodyData((InputStream)request.getInputStream(), request.getContentType(), output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readBodyData(InputStream input, String contentType, OutputStream output) throws IOException {
        int total = 0;
        byte[] bdr = this.getBoundary(contentType);
        byte[] boundary = new byte[bdr.length + BOUNDARY_PREFIX.length];
        int keepRegion = boundary.length + 4;
        try {
            while (this.upResource_.getStatus() == 0) {
                int pad = this.tail - this.head > keepRegion ? keepRegion : this.tail - this.head;
                output.write(this.buffer, this.head, this.tail - this.head - pad);
                this.upResource_.addUploadedBytes(this.tail - this.head - pad);
                total += this.tail - this.head - pad;
                System.arraycopy(this.buffer, this.tail - pad, this.buffer, 0, pad);
                this.head = 0;
                int bytesRead = input.read(this.buffer, pad, this.bufSize - pad);
                if (bytesRead != -1) {
                    this.tail = pad + bytesRead;
                    continue;
                }
                output.flush();
                total += pad;
                break;
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    Map<String, String> parseHeaders(InputStream input, String headerEncoding) throws IOException {
        String txtHeaders = this.readHeaders(input, headerEncoding);
        return this.parseHeaders(txtHeaders);
    }

    Map<String, String> parseHeaders(String headerPart) {
        HashMap<String, String> headers = new HashMap<String, String>();
        char[] chars = new char[1024];
        boolean done = false;
        int j = 0;
        while (!done) {
            int i = 0;
            while (i < 2 || chars[i - 2] != '\r' || chars[i - 1] != '\n') {
                chars[i++] = headerPart.charAt(j++);
            }
            String header = new String(chars, 0, i - 2);
            if (header.length() < 1) {
                done = true;
                continue;
            }
            if (header.indexOf(58) == -1) continue;
            String headerName = header.substring(0, header.indexOf(58)).trim().toLowerCase();
            String headerValue = header.substring(header.indexOf(58) + 1).trim();
            if (this.getHeader(headers, headerName) != null) {
                headers.put(headerName, this.getHeader(headers, headerName) + ',' + headerValue);
                continue;
            }
            headers.put(headerName, headerValue);
        }
        return headers;
    }

    private String getHeader(Map<String, String> headers, String name) {
        return headers.get(name.toLowerCase());
    }

    private String readHeaders(InputStream input, String headerEncoding) throws IOException {
        int i = 0;
        byte[] b = new byte[1];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int sizeMax = 10240;
        int size = 0;
        while (i < HEADER_SEPARATOR.length) {
            try {
                b[0] = this.readByte(input);
            }
            catch (IOException e) {
                throw new IOException("Stream ended unexpectedly");
            }
            i = b[0] == HEADER_SEPARATOR[i] ? ++i : 0;
            if (++size > sizeMax) continue;
            baos.write(b[0]);
        }
        if (headerEncoding != null) {
            try {
                return baos.toString(headerEncoding);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return baos.toString("UTF-8");
    }

    private byte readByte(InputStream input) throws IOException {
        if (this.head != this.tail) {
            return this.buffer[this.head++];
        }
        this.head = 0;
        this.tail = input.read(this.buffer, this.head, this.bufSize);
        if (this.tail == -1) {
            throw new IOException("No more data is available");
        }
        return this.buffer[this.head++];
    }

    private byte[] getBoundary(String contentType) {
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(contentType, ';');
        String boundaryStr = params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            return boundaryStr.getBytes("ISO-8859-1");
        }
        catch (Exception e) {
            return boundaryStr.getBytes();
        }
    }

    String getFileName(Map<String, String> headers) {
        String cd = this.getHeader(headers, CONTENT_DISPOSITION);
        if (cd == null) {
            return null;
        }
        String cdl = cd.toLowerCase();
        if (!cdl.startsWith(FORM_DATA) && !cdl.startsWith(ATTACHMENT)) {
            return null;
        }
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(cd, ';');
        if (params.containsKey("filename")) {
            String fileName = params.get("filename");
            if ((fileName = this.refsDecoder_.decode(fileName)) != null) {
                return fileName.trim();
            }
            return "";
        }
        return null;
    }
}

