/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.security;

import java.security.Security;
import org.jboss.logging.Logger;

public final class SecurityConfig {
    private static SecurityConfig singleton = null;
    private static Logger log = Logger.getLogger(SecurityConfig.class);
    private static final String PACKAGE_ACCESS = "sun.,org.apache.catalina.,org.apache.jasper.,org.apache.coyote.,org.apache.tomcat.";
    private static final String PACKAGE_DEFINITION = "java.,sun.,org.apache.catalina.,org.apache.coyote.,org.apache.tomcat.,org.apache.jasper.";
    private String packageDefinition = System.getProperty("package.definition");
    private String packageAccess = System.getProperty("package.access");

    private SecurityConfig() {
    }

    public static SecurityConfig newInstance() {
        if (singleton == null) {
            singleton = new SecurityConfig();
        }
        return singleton;
    }

    public void setPackageAccess() {
        if (this.packageAccess == null) {
            this.setSecurityProperty("package.access", PACKAGE_ACCESS);
        } else {
            this.setSecurityProperty("package.access", this.packageAccess);
        }
    }

    public void setPackageDefinition() {
        if (this.packageDefinition == null) {
            this.setSecurityProperty("package.definition", PACKAGE_DEFINITION);
        } else {
            this.setSecurityProperty("package.definition", this.packageDefinition);
        }
    }

    private final void setSecurityProperty(String properties, String packageList) {
        if (System.getSecurityManager() != null) {
            String definition = Security.getProperty(properties);
            if (definition != null && definition.length() > 0) {
                definition = definition + ",";
            }
            Security.setProperty(properties, definition + packageList);
        }
    }
}

