/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.security.authentication;

import java.security.Principal;
import java.security.acl.Group;
import javax.security.auth.Subject;
import org.apache.cxf.common.security.SecurityToken;
import org.apache.cxf.common.security.TokenType;
import org.apache.cxf.common.security.UsernameToken;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.security.SecurityContext;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.security.SecurityDomainContext;
import org.jboss.wsf.stack.cxf.security.authentication.SubjectCreator;
import org.jboss.wsf.stack.cxf.security.nonce.NonceStore;

public class SubjectCreatingPolicyInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static Logger LOG = Logger.getLogger(SubjectCreatingPolicyInterceptor.class);
    private SubjectCreator helper = new SubjectCreator();

    public SubjectCreatingPolicyInterceptor() {
        super("pre-invoke");
        this.helper.setPropagateContext(true);
    }

    public void handleMessage(Message message) throws Fault {
        Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
        SecurityDomainContext sdc = ep.getSecurityDomainContext();
        SecurityContext context = (SecurityContext)message.get(SecurityContext.class);
        if (context == null || context.getUserPrincipal() == null) {
            LOG.error((Object)"User Principal is not available on the current message");
            return;
        }
        SecurityToken token = (SecurityToken)message.get(SecurityToken.class);
        Subject subject = null;
        if (token != null) {
            if (token.getTokenType() != TokenType.UsernameToken) {
                this.reportSecurityException("Unsupported token type " + token.getTokenType().toString());
            }
            UsernameToken ut = (UsernameToken)token;
            subject = this.createSubject(sdc, ut.getName(), ut.getPassword(), ut.isHashed(), ut.getNonce(), ut.getCreatedTime());
        } else {
            Principal p = context.getUserPrincipal();
            if (!(p instanceof WSUsernameTokenPrincipal)) {
                this.reportSecurityException("Could not get subject info neither from Security Token in the current message nor directly from computed SecurityContext");
            }
            WSUsernameTokenPrincipal up = (WSUsernameTokenPrincipal)p;
            subject = this.createSubject(sdc, up.getName(), up.getPassword(), up.isPasswordDigest(), up.getNonce(), up.getCreatedTime());
        }
        Principal principal = this.getPrincipal(context.getUserPrincipal(), subject);
        message.put(SecurityContext.class, (Object)this.createSecurityContext(principal, subject));
    }

    private Subject createSubject(SecurityDomainContext sdc, String name, String password, boolean isDigest, String nonce, String creationTime) {
        Subject subject = null;
        try {
            subject = this.helper.createSubject(sdc, name, password, isDigest, nonce, creationTime);
        }
        catch (Exception ex) {
            this.reportSecurityException("Failed Authentication : Subject has not been created, " + ex.getMessage());
        }
        if (subject == null || subject.getPrincipals().size() == 0) {
            this.reportSecurityException("Failed Authentication : Invalid Subject");
        }
        return subject;
    }

    protected Principal getPrincipal(Principal originalPrincipal, Subject subject) {
        Principal[] ps = subject.getPrincipals().toArray(new Principal[0]);
        if (ps != null && ps.length > 0 && !(ps[0] instanceof Group)) {
            return ps[0];
        }
        return originalPrincipal;
    }

    protected SecurityContext createSecurityContext(Principal p, Subject subject) {
        return new DefaultSecurityContext(p, subject);
    }

    protected void reportSecurityException(String errorMessage) {
        LOG.error((Object)errorMessage);
        throw new SecurityException(errorMessage);
    }

    public void setPropagateContext(boolean propagateContext) {
        this.helper.setPropagateContext(propagateContext);
    }

    public void setTimestampThreshold(int timestampThreshold) {
        this.helper.setTimestampThreshold(timestampThreshold);
    }

    public void setNonceStore(NonceStore nonceStore) {
        this.helper.setNonceStore(nonceStore);
    }

    public void setDecodeNonce(boolean decodeNonce) {
        this.helper.setDecodeNonce(decodeNonce);
    }
}

