/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.organization;

import java.util.ArrayList;
import javax.portlet.ActionResponse;
import javax.xml.namespace.QName;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.InitParams;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.validator.Validator;
import org.exoplatform.webui.organization.UIAccountInputSet;
import org.exoplatform.webui.organization.UIUserProfileInputSet;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", initParams={@ParamConfig(name="AccountTemplateConfigOption", value="app:/WEB-INF/conf/uiconf/account/webui/component/model/AccountTemplateConfigOption.groovy"), @ParamConfig(name="help.UIAccountFormQuickHelp", value="app:/WEB-INF/conf/uiconf/account/webui/component/model/UIAccountFormQuickHelp.xhtml")}, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ResetActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchUserActionListener.class}, phase=Event.Phase.DECODE)})
@Serialized
public class UIAccountForm
extends UIFormTabPane {
    public UIAccountForm(InitParams initParams) throws Exception {
        super("UIAccountForm");
        UIAccountInputSet accountInputSet = new UIAccountInputSet("AccountInputSet");
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData addCategory = new UIFormInputWithActions.ActionData();
        addCategory.setActionListener("SearchUser");
        addCategory.setActionType(0);
        addCategory.setActionName("SearchUser");
        addCategory.setCssIconClass("SearchIcon");
        actions.add(addCategory);
        accountInputSet.setActionField("username", actions);
        this.setSelectedTab(accountInputSet.getId());
        this.addChild((UIComponent)accountInputSet);
        UIUserProfileInputSet userProfileSet = new UIUserProfileInputSet("UIUserProfileInputSet");
        this.addUIFormInput(userProfileSet);
        if (initParams == null) {
            return;
        }
        this.setActions(new String[]{"Save", "Reset"});
    }

    public String getSelectPortalTemplate() {
        return "SelectPortalTemplate";
    }

    public void reset() {
        ((UIAccountInputSet)this.getChild(UIAccountInputSet.class)).reset();
        ((UIUserProfileInputSet)this.getChild(UIUserProfileInputSet.class)).reset();
    }

    public static class SearchUserActionListener
    extends EventListener<UIAccountForm> {
        public void execute(Event<UIAccountForm> event) throws Exception {
            UIAccountForm uiForm = (UIAccountForm)((Object)event.getSource());
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            UIApplication uiApp = context.getUIApplication();
            OrganizationService service = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            UIFormStringInput usernameInput = ((UIAccountInputSet)uiForm.getChild(UIAccountInputSet.class)).getUIStringInput("username");
            for (Validator validator : usernameInput.getValidators()) {
                try {
                    validator.validate((UIFormInput)usernameInput);
                }
                catch (MessageException e) {
                    uiApp.addMessage(e.getDetailMessage());
                    return;
                }
            }
            String userName = (String)usernameInput.getValue();
            if (service.getUserHandler().findUserByName(userName, UserStatus.ANY) != null) {
                uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.user-exist", null, 1));
                return;
            }
            uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.user-not-exist", null, 2));
        }
    }

    public static class ResetActionListener
    extends EventListener<UIAccountForm> {
        public void execute(Event<UIAccountForm> event) throws Exception {
            UIAccountForm uiForm = (UIAccountForm)((Object)event.getSource());
            uiForm.reset();
        }
    }

    public static class SaveActionListener
    extends EventListener<UIAccountForm> {
        public void execute(Event<UIAccountForm> event) throws Exception {
            UIAccountForm uiForm = (UIAccountForm)((Object)event.getSource());
            OrganizationService service = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            UIAccountInputSet uiAccountInput = (UIAccountInputSet)uiForm.getChild(UIAccountInputSet.class);
            String userName = uiAccountInput.getUserName();
            boolean saveAccountInput = uiAccountInput.save(service, true);
            if (!saveAccountInput) {
                return;
            }
            ((UIUserProfileInputSet)uiForm.getChild(UIUserProfileInputSet.class)).save(service, userName, true);
            uiForm.reset();
            ActionResponse actResponse = (ActionResponse)event.getRequestContext().getResponse();
            actResponse.setEvent(new QName("NewAccountAdded"), null);
        }
    }
}

