/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.portal;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.DataStorage;
import org.jboss.logging.Logger;

public class PortalContext {
    private static Logger log = Logger.getLogger((String)"org.gatein.as7.portal");
    private final String portalContainerName;

    public PortalContext(String portalContainerName) {
        this.portalContainerName = portalContainerName;
    }

    public String getPortalContainerName() {
        return this.portalContainerName;
    }

    public static Logger getLog() {
        return log;
    }

    public Set<String> getSites() {
        try {
            return this.execute(new Request<Set<String>>(){

                @Override
                public Set<String> within(PortalContainer container) throws Exception {
                    DataStorage dataStorage = this.getComponent(DataStorage.class, container);
                    List names = dataStorage.getAllPortalNames();
                    return new LinkedHashSet<String>(names);
                }
            });
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve list of sites.", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public <T> T execute(Request<T> request) throws Exception {
        return this.doExecute(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doExecute(Request<T> request) throws Exception {
        PortalContainer original = PortalContainer.getInstance();
        RootContainer root = RootContainer.getInstance();
        PortalContainer container = null;
        if (root != null) {
            container = root.getPortalContainer(this.portalContainerName);
        }
        PortalContainer.setInstance(container);
        if (container != null) {
            RequestLifeCycle.begin((ExoContainer)container);
        }
        try {
            T t = request.within(container);
            return t;
        }
        finally {
            if (container != null) {
                RequestLifeCycle.end();
            }
            PortalContainer.setInstance((PortalContainer)original);
        }
    }

    public static abstract class Request<T> {
        public <S> S getComponent(Class<S> type, PortalContainer container) {
            if (container == null) {
                return null;
            }
            Object service = container.getComponentInstanceOfType(type);
            return service != null ? (S)type.cast(service) : null;
        }

        public abstract T within(PortalContainer var1) throws Exception;
    }
}

