/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class DeploymentScannerService
implements Service<DeploymentScannerService> {
    public static final ServiceName NAME = ServiceName.of((String[])new String[]{"org", "gatein", "deployment", "scanner"});
    private static final Logger log = Logger.getLogger((String)"org.gatein");
    private static final String GATEIN_EAR = "gatein.ear";
    private String deployRoot = "gatein";
    private String extensionsSub = "extensions";
    private File gateinHome;
    private GateInConfiguration config;

    public DeploymentScannerService(GateInConfiguration config) {
        this.config = config;
        String jbossHome = System.getProperty("jboss.home.dir");
        if (jbossHome == null) {
            jbossHome = System.getProperty("user.dir");
            log.warn((Object)("System property jboss.home.dir not set! Using current working dir: " + jbossHome));
        }
        this.gateinHome = new File(jbossHome);
    }

    public ModelNode prepareDeploymentModel() {
        File[] extensions;
        File deployDir = new File(this.gateinHome, this.deployRoot);
        LinkedList<File> deployments = new LinkedList<File>();
        File gateinEar = new File(deployDir, GATEIN_EAR);
        if (!gateinEar.exists()) {
            throw new RuntimeException("GateIn deployment archive not found: " + gateinEar);
        }
        deployments.add(gateinEar);
        File extensionsDir = new File(deployDir, this.extensionsSub);
        for (File ext : extensions = extensionsDir.listFiles()) {
            String name = ext.getName();
            if (name.endsWith(".war") || name.endsWith(".ear") || name.endsWith(".jar")) {
                deployments.add(ext);
                continue;
            }
            log.warn((Object)("Skipped gatein extension deployment for: " + ext));
        }
        this.configureExtensions(deployments);
        return this.composeDeployOperation(deployments);
    }

    private void configureExtensions(List<File> deployments) {
        this.config.clearDeploymentArchives();
        String gateinEar = GATEIN_EAR;
        for (File archive : deployments) {
            this.config.addDeploymentArchive(archive.getName(), archive.getName().equals(gateinEar));
        }
    }

    private ModelNode composeDeployOperation(Collection<File> deployments) {
        ModelNode deployOperation = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
        ModelNode allSteps = deployOperation.get("steps");
        for (File deployment : deployments) {
            ModelNode address = new ModelNode().add("deployment", deployment.getName());
            ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)address);
            ModelNode content = new ModelNode();
            ModelNode contentItem = content.get(0);
            contentItem.get("path").set(this.getRelativePath(deployment));
            contentItem.get("relative-to").set("jboss.home.dir");
            contentItem.get("archive").set(false);
            addOp.get("content").set(content);
            addOp.get("persistent").set(false);
            ModelNode deployOp = Util.getEmptyOperation((String)"deploy", (ModelNode)address);
            ModelNode op = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
            ModelNode steps = op.get("steps");
            steps.add(addOp);
            steps.add(deployOp);
            allSteps.add(op);
        }
        return deployOperation;
    }

    private String getRelativePath(File deployment) {
        String root;
        String pathName = deployment.getPath();
        if (!pathName.startsWith(root = this.gateinHome.getPath() + File.separatorChar)) {
            throw new IllegalStateException("Deployment archive path outside JBOSS_HOME (" + this.gateinHome + "): " + pathName);
        }
        return pathName.substring(root.length());
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public DeploymentScannerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

