/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment;

import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.gatein.integration.jboss.as7.GateInExtension;
import org.gatein.integration.jboss.as7.deployment.GateInConfigurationKey;
import org.gatein.integration.jboss.as7.deployment.GateInEarKey;
import org.gatein.integration.jboss.as7.web.InitService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class GateInInitDeploymentProcessor
implements DeploymentUnitProcessor {
    private final Logger log = Logger.getLogger(GateInInitDeploymentProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit du = phaseContext.getDeploymentUnit();
        if (GateInConfiguration.isGateInArchive(du)) {
            this.log.info((Object)"Module is on GateIn Extension modules list");
            GateInConfiguration config = (GateInConfiguration)du.getAttachment(GateInConfigurationKey.KEY);
            ServiceName initSvcName = GateInExtension.deploymentUnitName(config.getGateInEarModule(), "gatein", "init");
            ServiceTarget target = phaseContext.getServiceTarget();
            if (du.getAttachment(GateInEarKey.KEY) != null) {
                ServiceBuilder builder = target.addService(initSvcName, (Service)new InitService(config)).addDependency(GateInExtension.deploymentUnitName(config.getGateInEarModule(), Phase.POST_MODULE));
                for (ModuleIdentifier module : config.getGateInExtModules()) {
                    builder.addDependency(GateInExtension.deploymentUnitName(module, Phase.POST_MODULE));
                }
                builder.install();
                this.log.info((Object)("Installed " + initSvcName));
            }
            phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, (Object)initSvcName);
            this.log.info((Object)("Added NEXT_PHASE_DEP on " + initSvcName));
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

