/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.parser.jsp.TldMetaDataParser;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

class SharedPortletTldsMetaDataBuilder {
    private static final String[] PORTLET_TLDS = new String[]{"portlet.tld", "portlet_2_0.tld"};
    private final List<TldMetaData> tlds = new ArrayList<TldMetaData>();

    SharedPortletTldsMetaDataBuilder() {
        this.init();
    }

    private void init() {
        try {
            ModuleClassLoader jstl = Module.getModuleFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.create((String)"org.gatein.pc")).getClassLoader();
            for (String tld : PORTLET_TLDS) {
                InputStream is = jstl.getResourceAsStream("META-INF/" + tld);
                if (is == null) continue;
                TldMetaData tldMetaData = this.parseTLD(tld, is);
                this.tlds.add(tldMetaData);
            }
        }
        catch (ModuleLoadException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    List<TldMetaData> create() {
        ArrayList<TldMetaData> metadata = new ArrayList<TldMetaData>();
        metadata.addAll(this.tlds);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldMetaData parseTLD(String tld, InputStream is) throws Exception {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(NoopXMLResolver.create());
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
            TldMetaData tldMetaData = TldMetaDataParser.parse((XMLStreamReader)xmlReader);
            return tldMetaData;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

