/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gatein.integration.jboss.as7.Attribute;
import org.gatein.integration.jboss.as7.Element;
import org.gatein.integration.jboss.as7.PortletWarDependencyDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class GateInSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final GateInSubsystemParser INSTANCE = new GateInSubsystemParser();

    static GateInSubsystemParser getInstance() {
        return INSTANCE;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement("urn:jboss:domain:gatein:1.0", false);
        ModelNode node = context.getModelNode();
        if (node.hasDefined("portlet-war-dependency")) {
            this.writePortletWarDependencies(writer, node.get("portlet-war-dependency"));
        }
        writer.writeEndElement();
    }

    private void writePortletWarDependencies(XMLExtendedStreamWriter writer, ModelNode warDependencies) throws XMLStreamException {
        if (warDependencies.isDefined() && warDependencies.asInt() > 0) {
            writer.writeStartElement(Element.PORTLET_WAR_DEPENDENCIES.getLocalName());
            for (Property dependency : warDependencies.asPropertyList()) {
                writer.writeStartElement(Element.DEPENDENCY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), dependency.getName());
                ModelNode model = dependency.getValue();
                PortletWarDependencyDefinition.IMPORT_SERVICES.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode address = new ModelNode();
        address.add("subsystem", "gatein");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        }
        list.add(subsystem);
        boolean hasArchives = false;
        boolean hasDependencies = false;
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            if ("urn:jboss:domain:gatein:1.0".equals(reader.getNamespaceURI())) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case PORTLET_WAR_DEPENDENCIES: {
                        GateInSubsystemParser.parsePortletWarDependencies(reader, address, list);
                        hasDependencies = true;
                        continue block4;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!hasDependencies) {
            GateInSubsystemParser.addDefaultPortletWarDependencies(reader, address, list);
        }
    }

    static void parsePortletWarDependencies(XMLExtendedStreamReader reader, ModelNode parent, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean gotDependencies = false;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DEPENDENCY: {
                    GateInSubsystemParser.parseDependency(reader, parent, operations);
                    gotDependencies = true;
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!gotDependencies) {
            GateInSubsystemParser.addDefaultPortletWarDependencies(reader, parent, operations);
        }
    }

    private static void addDefaultPortletWarDependencies(XMLExtendedStreamReader reader, ModelNode parent, List<ModelNode> operations) throws XMLStreamException {
        GateInSubsystemParser.addPortletWarDependencyOperation(parent, new ModelNode(), "org.gatein.wci", operations);
        GateInSubsystemParser.addPortletWarDependencyOperation(parent, new ModelNode(), "org.gatein.pc", operations);
        GateInSubsystemParser.addPortletWarDependencyOperation(parent, new ModelNode(), "javax.portlet.api", operations);
    }

    static void parseDependency(XMLExtendedStreamReader reader, ModelNode parent, List<ModelNode> operations) throws XMLStreamException {
        ModelNode model = new ModelNode();
        int count = reader.getAttributeCount();
        String name = null;
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case IMPORT_SERVICES: {
                    PortletWarDependencyDefinition.IMPORT_SERVICES.parseAndSetParameter(value, model, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        GateInSubsystemParser.addPortletWarDependencyOperation(parent, model, name, operations);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void addPortletWarDependencyOperation(ModelNode parent, ModelNode model, String name, List<ModelNode> operations) {
        ModelNode address = parent.clone();
        address.add("portlet-war-dependency", name);
        model.get("operation").set("add");
        model.get("address").set(address);
        operations.add(model);
    }
}

