/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment;

import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.vfs.VirtualFile;

public class CdiContextDependencyProcessor
implements DeploymentUnitProcessor {
    private static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    private static final ModuleIdentifier CDI_CONTEXTS = ModuleIdentifier.create((String)"org.gatein.cdi-contexts");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        VirtualFile rootBeansXml;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (!GateInConfiguration.isPortletArchive(deploymentUnit)) {
            return;
        }
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (null == deploymentRoot) {
            return;
        }
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit) && (rootBeansXml = deploymentRoot.getRoot().getChild(WEB_INF_BEANS_XML)).exists() && rootBeansXml.isFile()) {
            ModuleDependency cdiContexts = new ModuleDependency(moduleLoader, CDI_CONTEXTS, false, false, false, false);
            moduleSpecification.addSystemDependency(cdiContexts);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

