/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment;

import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.WebFragmentMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.portletbridge.listener.PortletBridgeListener;

public class PortletBridgeDependencyProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger(PortletBridgeDependencyProcessor.class);
    private static final ModuleIdentifier CDI_PORTLET_INTEGRATION = ModuleIdentifier.create((String)"org.gatein.cdi-portlet-integration");
    private static final ModuleIdentifier COMMONS_FILEUPLOAD = ModuleIdentifier.create((String)"org.apache.commons.fileupload");
    private static final ModuleIdentifier JSF_API = ModuleIdentifier.create((String)"javax.faces.api");
    private static final ModuleIdentifier JSF_IMPL = ModuleIdentifier.create((String)"com.sun.jsf-impl");
    private static final ModuleIdentifier PORTLETBRIDGE_API = ModuleIdentifier.create((String)"org.jboss.portletbridge.api");
    private static final ModuleIdentifier PORTLETBRIDGE_IMPL = ModuleIdentifier.create((String)"org.jboss.portletbridge.impl");
    private static final String cdiPortletIntegrationVersion = PortletBridgeDependencyProcessor.getCdiPortletIntegrationVersion();
    private static final String portletBridgeVersion = PortletBridgeDependencyProcessor.getPortletBridgeVersion();
    private static final String PBR_LISTENER = PortletBridgeListener.class.getName();
    public static final String WAR_BUNDLES_PORTLETBRIDGE_PARAM = "org.gatein.portletbridge.WAR_BUNDLES_PORTLETBRIDGE";
    public static final String DISABLE_CDI_INTEGRATION_PARAM = "org.gatein.cdi.DISABLE_CDI_INTEGRATION";
    private final ListenerMetaData cdiListener = new ListenerMetaData();

    public PortletBridgeDependencyProcessor() {
        this.cdiListener.setListenerClass(PBR_LISTENER);
    }

    private static String getCdiPortletIntegrationVersion() {
        try {
            Module module = Module.getBootModuleLoader().loadModule(CDI_PORTLET_INTEGRATION);
            Manifest mf = new Manifest(module.getClassLoader().getResourceAsStream("/META-INF/MANIFEST.MF"));
            return mf.getMainAttributes().getValue("Implementation-Version");
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String getPortletBridgeVersion() {
        try {
            Module module = Module.getBootModuleLoader().loadModule(PORTLETBRIDGE_IMPL);
            Manifest mf = new Manifest(module.getClassLoader().getResourceAsStream("/META-INF/MANIFEST.MF"));
            return mf.getMainAttributes().getValue("Implementation-Version");
        }
        catch (Exception e) {
            return "";
        }
    }

    private void addCdiPortletIntegration(DeploymentUnit deploymentUnit, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        ModuleDependency pbr = new ModuleDependency(moduleLoader, CDI_PORTLET_INTEGRATION, false, false, false, false);
        moduleSpecification.addSystemDependency(pbr);
    }

    private void addPortletBridgeApi(DeploymentUnit deploymentUnit, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        ModuleDependency pbr = new ModuleDependency(moduleLoader, PORTLETBRIDGE_API, false, false, false, false);
        moduleSpecification.addSystemDependency(pbr);
    }

    private void addPortletBridgeDependencies(DeploymentUnit deploymentUnit, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        ModuleDependency pbr = new ModuleDependency(moduleLoader, COMMONS_FILEUPLOAD, false, false, false, false);
        moduleSpecification.addSystemDependency(pbr);
    }

    private void addPortletBridgeImpl(DeploymentUnit deploymentUnit, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        try {
            Module module = moduleLoader.loadModule(PORTLETBRIDGE_IMPL);
            URL url = module.getClassLoader().getResource("org/jboss/portletbridge/PortletBridgeImpl.class");
            URLConnection connection = url.openConnection();
            if (!(connection instanceof JarURLConnection)) {
                throw new RuntimeException("portletbridge-impl not found");
            }
            JarFile jarFile = ((JarURLConnection)connection).getJarFile();
            moduleSpecification.addResourceLoader(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((String)"portletbridge-impl", (JarFile)jarFile)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!GateInConfiguration.isPortletArchive(deploymentUnit)) {
            return;
        }
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        if (this.isJsfDependencies(moduleSpecification) && !this.isPortletBridgeBundled(deploymentUnit)) {
            log.infof("Adding JBoss Portlet Bridge %s to \"%s\"", (Object)portletBridgeVersion, (Object)deploymentUnit.getName());
            this.addPortletBridgeApi(deploymentUnit, moduleSpecification, moduleLoader);
            this.addPortletBridgeImpl(deploymentUnit, moduleSpecification, moduleLoader);
            this.addPortletBridgeDependencies(deploymentUnit, moduleSpecification, moduleLoader);
            this.addPortletBridgeListener(deploymentUnit);
            if (this.isCdiDeployment(deploymentUnit) && !this.disableCdiIntegration(deploymentUnit)) {
                log.infof("Adding CDI Portlet Integration %s to \"%s\"", (Object)cdiPortletIntegrationVersion, (Object)deploymentUnit.getName());
                this.addCdiPortletIntegration(deploymentUnit, moduleSpecification, moduleLoader);
            }
        }
    }

    private void addPortletBridgeListener(DeploymentUnit deploymentUnit) {
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            log.debug((Object)"Not installing Portlet Bridge web tier integration as no war metadata found");
            return;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            log.debug((Object)"Not installing Portlet Bridge web tier integration as no merged web metadata found");
            return;
        }
        ArrayList<ListenerMetaData> listeners = webMetaData.getListeners();
        if (listeners == null) {
            listeners = new ArrayList<ListenerMetaData>();
            webMetaData.setListeners(listeners);
        } else {
            ListIterator iterator = listeners.listIterator();
            while (iterator.hasNext()) {
                ListenerMetaData listener = (ListenerMetaData)iterator.next();
                if (!listener.getListenerClass().trim().equals(PBR_LISTENER)) continue;
                log.debugf("Removing portlet bridge listener %s from web config, as it is not needed in EE6 environments", (Object)PBR_LISTENER);
                iterator.remove();
                break;
            }
        }
        listeners.add(0, this.cdiListener);
    }

    private boolean isCdiDeployment(DeploymentUnit deploymentUnit) {
        return WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit);
    }

    private boolean isJsfDependencies(ModuleSpecification moduleSpecification) {
        boolean jsfApi = false;
        boolean jsfImpl = false;
        for (ModuleDependency d : moduleSpecification.getSystemDependencies()) {
            if (d.getIdentifier().equals(JSF_API)) {
                jsfApi = true;
            }
            if (!d.getIdentifier().equals(JSF_IMPL)) continue;
            jsfImpl = true;
        }
        return jsfApi && jsfImpl;
    }

    private boolean isPortletBridgeBundled(DeploymentUnit deploymentUnit) {
        WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (metaData == null) {
            return false;
        }
        ArrayList contextParams = new ArrayList();
        if (metaData.getWebMetaData() != null && metaData.getWebMetaData().getContextParams() != null) {
            contextParams.addAll(metaData.getWebMetaData().getContextParams());
        }
        if (metaData.getWebFragmentsMetaData() != null) {
            for (WebFragmentMetaData fragmentMetaData : metaData.getWebFragmentsMetaData().values()) {
                if (fragmentMetaData.getContextParams() == null) continue;
                contextParams.addAll(fragmentMetaData.getContextParams());
            }
        }
        for (ParamValueMetaData param : contextParams) {
            if (!param.getParamName().equals(WAR_BUNDLES_PORTLETBRIDGE_PARAM) || param.getParamValue() == null || !param.getParamValue().toLowerCase(Locale.ENGLISH).equals("true")) continue;
            return true;
        }
        return false;
    }

    private boolean disableCdiIntegration(DeploymentUnit deploymentUnit) {
        WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (metaData == null) {
            return false;
        }
        ArrayList contextParams = new ArrayList();
        if (metaData.getWebMetaData() != null && metaData.getWebMetaData().getContextParams() != null) {
            contextParams.addAll(metaData.getWebMetaData().getContextParams());
        }
        if (metaData.getWebFragmentsMetaData() != null) {
            for (WebFragmentMetaData fragmentMetaData : metaData.getWebFragmentsMetaData().values()) {
                if (fragmentMetaData.getContextParams() == null) continue;
                contextParams.addAll(fragmentMetaData.getContextParams());
            }
        }
        for (ParamValueMetaData param : contextParams) {
            if (!param.getParamName().equals(DISABLE_CDI_INTEGRATION_PARAM) || param.getParamValue() == null || !param.getParamValue().toLowerCase(Locale.ENGLISH).equals("true")) continue;
            return true;
        }
        return false;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

