/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment.wsrp;

import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarFile;
import org.gatein.integration.jboss.as7.deployment.GateInExtKey;
import org.gatein.integration.jboss.as7.deployment.wsrp.GateInWSRPKey;
import org.gatein.integration.jboss.as7.deployment.wsrp.WSRPPostModuleDeploymentProcessor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.vfs.VirtualFile;

public class WSRPStructureDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger(WSRPStructureDeploymentProcessor.class);
    private final List<ModuleDependency> loadedPluginsAsDependencies = new ArrayList<ModuleDependency>(7);
    private AtomicReference<ResourceLoaderSpec> resourceLoaderSpec = new AtomicReference<Object>(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit du = phaseContext.getDeploymentUnit();
        if (this.isWSRPPlugin(du)) {
            du.putAttachment(GateInWSRPKey.KEY, (Object)GateInWSRPKey.INSTANCE);
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            ServiceModuleLoader pluginModuleLoader = (ServiceModuleLoader)du.getAttachment(Attachments.SERVICE_MODULE_LOADER);
            ModuleIdentifier moduleIdentifier = (ModuleIdentifier)du.getAttachment(Attachments.MODULE_IDENTIFIER);
            WSRPStructureDeploymentProcessor wSRPStructureDeploymentProcessor = this;
            synchronized (wSRPStructureDeploymentProcessor) {
                this.loadedPluginsAsDependencies.add(new ModuleDependency((ModuleLoader)pluginModuleLoader, moduleIdentifier, false, false, false, false));
            }
            ModuleSpecification moduleSpecification = (ModuleSpecification)du.getAttachment(Attachments.MODULE_SPECIFICATION);
            ModuleDependency dependency = new ModuleDependency(moduleLoader, ModuleIdentifier.fromString((String)"org.gatein.wsrp"), false, false, false, false);
            moduleSpecification.addSystemDependency(dependency);
            dependency = new ModuleDependency(moduleLoader, ModuleIdentifier.fromString((String)"org.gatein.pc"), false, false, false, false);
            moduleSpecification.addSystemDependency(dependency);
            dependency = new ModuleDependency(moduleLoader, ModuleIdentifier.fromString((String)"org.apache.ws.security"), false, false, false, false);
            moduleSpecification.addSystemDependency(dependency);
            dependency = new ModuleDependency(moduleLoader, ModuleIdentifier.fromString((String)"org.gatein.wsrp.integration"), false, false, false, false);
            moduleSpecification.addSystemDependency(dependency);
            log.infof("Adding WSRP, PC & Apache WS Security dependencies to %s", (Object)du.getName());
        } else {
            ModuleSpecification moduleSpecification;
            String name = du.getName();
            boolean isWSRPAdmin = name.contains("wsrp-admin-gui");
            if (isWSRPAdmin || name.contains("extension-war")) {
                moduleSpecification = (ModuleSpecification)du.getAttachment(Attachments.MODULE_SPECIFICATION);
                ModuleLoader moduleLoader = Module.getBootModuleLoader();
                if (this.resourceLoaderSpec.get() == null) {
                    try {
                        Module module = moduleLoader.loadModule(ModuleIdentifier.fromString((String)"org.gatein.wsrp.catalog"));
                        URL url = module.getClassLoader().getResource("META-INF/jax-ws-catalog.xml");
                        URLConnection connection = url.openConnection();
                        if (!(connection instanceof JarURLConnection)) {
                            throw new RuntimeException("JAX-WS catalog not found");
                        }
                        JarFile jarFile = ((JarURLConnection)connection).getJarFile();
                        this.resourceLoaderSpec.set(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((String)"wsrp-catalog", (JarFile)jarFile)));
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                moduleSpecification.addResourceLoader(this.resourceLoaderSpec.get());
                if (isWSRPAdmin) {
                    WSRPStructureDeploymentProcessor wSRPStructureDeploymentProcessor = this;
                    synchronized (wSRPStructureDeploymentProcessor) {
                        moduleSpecification.addLocalDependencies(this.loadedPluginsAsDependencies);
                    }
                    log.info((Object)("Adding " + this.loadedPluginsAsDependencies + " dependencies to WSRP admin module"));
                }
            }
            if (name.contains("wsrp-producer") || name.contains("portal.war")) {
                moduleSpecification = (ModuleSpecification)du.getAttachment(Attachments.MODULE_SPECIFICATION);
                WSRPStructureDeploymentProcessor wSRPStructureDeploymentProcessor = this;
                synchronized (wSRPStructureDeploymentProcessor) {
                    moduleSpecification.addLocalDependencies(this.loadedPluginsAsDependencies);
                }
                log.info((Object)("Adding " + this.loadedPluginsAsDependencies + " dependencies to WSRP producer module"));
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private boolean isWSRPPlugin(DeploymentUnit du) {
        ResourceRoot deploymentRoot;
        VirtualFile servicesDir;
        String name = du.getName();
        if (name.endsWith(".wsrp.jar")) {
            return true;
        }
        if (name.endsWith(".jar") && du.hasAttachment(GateInExtKey.KEY) && (servicesDir = (deploymentRoot = (ResourceRoot)du.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot().getChild("META-INF/services")).exists()) {
            for (String interfaceName : WSRPPostModuleDeploymentProcessor.KNOWN_PLUGIN_INTERFACE_NAMES) {
                if (!servicesDir.getChild(interfaceName).exists()) continue;
                return true;
            }
            log.debug((Object)("Looked at " + name + " using ServiceLoader but didn't contain any WSRP plugin marker. Ignoring."));
        }
        return false;
    }
}

