/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment;

import java.lang.reflect.Constructor;
import javax.enterprise.inject.spi.Extension;
import org.gatein.cdi.CDIPortletContextExtension;
import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.weld.metadata.MetadataImpl;

public class CdiContextExtensionProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger(CdiContextExtensionProcessor.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!GateInConfiguration.isPortletArchive(deploymentUnit)) {
            return;
        }
        if (!WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        DeploymentReflectionIndex index = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        Extension extension = this.loadExtension(CDIPortletContextExtension.class.getName(), index, (ClassLoader)module.getClassLoader());
        MetadataImpl metadata = new MetadataImpl((Object)extension, deploymentUnit.getName());
        log.debug((Object)("Loaded portable extension " + extension));
        deploymentUnit.addToAttachmentList(WeldAttachments.PORTABLE_EXTENSIONS, (Object)metadata);
    }

    private Extension loadExtension(String serviceClassName, DeploymentReflectionIndex index, ClassLoader loader) throws DeploymentUnitProcessingException {
        try {
            Class<?> clazz;
            Class<?> serviceClass = clazz = loader.loadClass(serviceClassName);
            Constructor ctor = index.getClassIndex(serviceClass).getConstructor(EMPTY_STRING_ARRAY);
            return (Extension)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new DeploymentUnitProcessingException("Service class " + serviceClassName + " didn't implement the javax.enterprise.inject.spi.Extension interface", (Throwable)e);
        }
        catch (Exception e) {
            log.warnf("Could not load portable extension class %s: %s", (Object)serviceClassName, (Object)e.getMessage());
            return null;
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

