/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portlet.responsive.header;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.web.security.sso.SSOHelper;
import org.exoplatform.webui.organization.OrganizationUtils;
import org.gatein.api.PortalRequest;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteId;
import org.gatein.api.site.SiteQuery;
import org.gatein.api.site.SiteType;
import org.gatein.portlet.responsive.header.NodeBean;

public class HeaderBean {
    private static final String GROUP_NAVIGATION_NODE = "groupnavigation";
    private static final String REGISTER_NODE = "register";
    private final SSOHelper ssoHelper;
    protected int nodeLevel;

    public HeaderBean(int nodeLevel) {
        this.nodeLevel = nodeLevel;
        this.ssoHelper = (SSOHelper)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SSOHelper.class);
    }

    public void setNodeLevel(int nodeLevel) {
        this.nodeLevel = nodeLevel;
    }

    public int getNodeLevel() {
        return this.nodeLevel;
    }

    public String generateLoginLink() {
        if (this.ssoHelper != null && this.ssoHelper.isSSOEnabled()) {
            PortalRequestContext pContext = Util.getPortalRequestContext();
            String ssoRedirectURL = pContext.getRequest().getContextPath() + this.ssoHelper.getSSORedirectURLSuffix();
            return ssoRedirectURL;
        }
        return "#";
    }

    public String generateLoginAction(String defaultAction) {
        if (this.ssoHelper != null && this.ssoHelper.isSSOEnabled()) {
            return "#";
        }
        return defaultAction;
    }

    public String generateRegisterLink() {
        PortalRequest portalRequest = PortalRequest.getInstance();
        String portalURL = portalRequest.getURIResolver().resolveURI(portalRequest.getSiteId());
        return portalURL + "/" + REGISTER_NODE;
    }

    public String generateHomePageLink() throws Exception {
        PortalRequest portalRequest = PortalRequest.getInstance();
        String portalURL = portalRequest.getURIResolver().resolveURI(portalRequest.getSiteId());
        return portalURL;
    }

    public String generateDashboardLink() throws Exception {
        PortalRequest portalRequest = PortalRequest.getInstance();
        return portalRequest.getURIResolver().resolveURI(new SiteId(portalRequest.getUser()));
    }

    public String generateGroupPagesLink() {
        Navigation navigation = PortalRequest.getInstance().getNavigation();
        Node navigationNode = navigation.getNode(new String[]{GROUP_NAVIGATION_NODE});
        if (navigationNode != null) {
            return navigationNode.getURI().toString();
        }
        return null;
    }

    public Map<String, NodeBean> getGroupNodes() throws Exception {
        HashMap<String, NodeBean> navNodes = new HashMap<String, NodeBean>();
        PortalRequest portalRequest = PortalRequest.getInstance();
        SiteQuery.Builder siteQueryBulder = new SiteQuery.Builder();
        SiteQuery siteQuery = siteQueryBulder.withSiteTypes(SiteType.SPACE, new SiteType[0]).includeEmptySites(false).build();
        List groupSites = PortalRequest.getInstance().getPortal().findSites(siteQuery);
        for (Site site : groupSites) {
            Navigation siteNavigation;
            Node node;
            if (!portalRequest.getPortal().hasPermission(portalRequest.getUser(), site.getAccessPermission()) || site.getName().equals("/platform/guests") || !(node = (siteNavigation = portalRequest.getPortal().getNavigation(site.getId())).getRootNode(Nodes.visitNodes((int)this.nodeLevel))).isVisible()) continue;
            String groupLabel = OrganizationUtils.getGroupLabel((String)siteNavigation.getSiteId().getName().toString());
            NodeBean nodeBean = new NodeBean(node, site.getId(), Boolean.valueOf(true));
            navNodes.put(groupLabel, nodeBean);
        }
        return navNodes;
    }
}

