/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portlet.responsive.header;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.gatein.api.PortalRequest;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.site.SiteId;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.portlet.responsive.header.NodeBean;

public abstract class NodePortlet
extends GenericPortlet {
    private static final Logger log = LoggerFactory.getLogger(NodePortlet.class);
    private final String EMPTY_CATEGORY_PROPERTY_NAME = "ShowEmptyCategories";
    public static final String NODE_RESOURCE_ID = "node";

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        String resourceID = request.getResourceID();
        if (resourceID != null && resourceID.equals(NODE_RESOURCE_ID)) {
            String siteId = request.getParameter("siteId");
            Navigation navigation = PortalRequest.getInstance().getPortal().getNavigation(SiteId.fromString((String)siteId));
            String chosenNodeURI = request.getParameter("uri");
            Node chosenNode = navigation.getNode(NodePath.fromString((String)chosenNodeURI), Nodes.visitNodes((int)this.getNodeLevel((PortletRequest)request)));
            boolean showEmptyCategory = this.getShowEmptyCategory((PortletRequest)request);
            NodeBean chosenNodeBean = this.generateNodeBean(chosenNode, SiteId.fromString((String)siteId), showEmptyCategory);
            request.setAttribute("showEmptyCategory", (Object)showEmptyCategory);
            request.setAttribute("parentNode", (Object)chosenNodeBean);
            PortletRequestDispatcher prd = this.getPortletContext().getRequestDispatcher("/jsp/node.jsp");
            prd.include((PortletRequest)request, (PortletResponse)response);
        }
    }

    protected NodeBean generateNodeBean(Node node, SiteId siteId, boolean showEmptyCategory) {
        NodeBean nodeBean = new NodeBean(node, siteId);
        List nodeChildrenList = this.getChildren(node, siteId, false, showEmptyCategory);
        if (!showEmptyCategory) {
            nodeBean.setEmptyCategory(this.isEmptyCategory(node));
        }
        nodeBean.setChildren(nodeChildrenList);
        return nodeBean;
    }

    private boolean isEmptyCategory(Node n) {
        if (n.getPageId() != null) {
            return false;
        }
        Navigation navigation = PortalRequest.getInstance().getNavigation();
        Iterator iterator = n.iterator();
        while (iterator.hasNext()) {
            Node child = navigation.getNode(((Node)iterator.next()).getNodePath(), Nodes.visitNodes((int)1));
            if (child == null || this.isEmptyCategory(child)) continue;
            return false;
        }
        return true;
    }

    private List<NodeBean> getChildren(Node node, SiteId siteId, boolean firstActive, boolean showEmptyCategory) {
        ArrayList<NodeBean> nodes = new ArrayList<NodeBean>();
        boolean firstActiveSet = false;
        for (Node childNode : node) {
            NodeBean childNodeBean = new NodeBean(childNode, siteId);
            if (firstActive && !firstActiveSet) {
                childNodeBean.setActive(true);
                firstActiveSet = true;
            }
            if (!showEmptyCategory) {
                childNodeBean.setEmptyCategory(this.isEmptyCategory(childNode));
            }
            nodes.add(childNodeBean);
        }
        return nodes;
    }

    protected boolean getShowEmptyCategory(PortletRequest request) {
        PortletPreferences portletPreferences = request.getPreferences();
        String showEmptyCategoryStringValue = portletPreferences.getValue("ShowEmptyCategories", "false");
        return Boolean.valueOf(showEmptyCategoryStringValue);
    }

    protected abstract int getNodeLevel(PortletRequest var1);
}

