/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portlet.responsive.navigation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.gatein.api.PortalRequest;
import org.gatein.api.navigation.FilteredNode;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.Nodes;
import org.gatein.portlet.responsive.navigation.NavigationNodeBean;

public class NavigationPortlet
extends GenericPortlet {
    private String EMPTY_CATEGORY_PROPERTY_NAME = "ShowEmptyCategories";

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortalRequest portalRequest = PortalRequest.getInstance();
        Navigation navigation = PortalRequest.getInstance().getNavigation();
        FilteredNode rootNode = navigation.getRootNode(Nodes.visitNodes((int)2)).filter().showDefault();
        NavigationNodeBean navigationRootNodeBean = new NavigationNodeBean((Node)rootNode);
        boolean showEmptyCategory = this.getShowEmptyCategory((PortletRequest)request);
        if (!showEmptyCategory) {
            navigationRootNodeBean.setEmptyCategory(this.isEmptyCategory((Node)rootNode));
        }
        boolean isRootNode = portalRequest.getNodePath().equals((Object)NodePath.root());
        List rootNodeChildrenList = this.getChildren((Node)rootNode, isRootNode, showEmptyCategory);
        navigationRootNodeBean.setChildren(rootNodeChildrenList);
        request.setAttribute("showEmptyCategory", (Object)showEmptyCategory);
        request.setAttribute("navigationRootNode", (Object)navigationRootNodeBean);
        PortletRequestDispatcher prd = this.getPortletContext().getRequestDispatcher("/jsp/navigation.jsp");
        prd.include(request, response);
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        Navigation navigation = PortalRequest.getInstance().getNavigation();
        String chosenNodeURI = request.getParameter("uri");
        FilteredNode chosenNode = navigation.getNode(NodePath.fromString((String)chosenNodeURI), Nodes.visitNodes((int)2)).filter().showDefault();
        NavigationNodeBean chosenNodeBean = new NavigationNodeBean((Node)chosenNode);
        boolean showEmptyCategory = this.getShowEmptyCategory((PortletRequest)request);
        List nodeChildrenList = this.getChildren((Node)chosenNode, false, showEmptyCategory);
        if (!showEmptyCategory) {
            chosenNodeBean.setEmptyCategory(this.isEmptyCategory((Node)chosenNode));
        }
        chosenNodeBean.setChildren(nodeChildrenList);
        request.setAttribute("showEmptyCategory", (Object)showEmptyCategory);
        request.setAttribute("parentNode", (Object)chosenNodeBean);
        PortletRequestDispatcher prd = this.getPortletContext().getRequestDispatcher("/jsp/node.jsp");
        prd.include((PortletRequest)request, (PortletResponse)response);
    }

    private boolean isEmptyCategory(Node n) {
        if (n.getPageId() != null) {
            return false;
        }
        Navigation navigation = PortalRequest.getInstance().getNavigation();
        Iterator iterator = n.iterator();
        while (iterator.hasNext()) {
            FilteredNode child = navigation.getNode(((Node)iterator.next()).getNodePath(), Nodes.visitNodes((int)1)).filter().showDefault();
            if (this.isEmptyCategory((Node)child)) continue;
            return false;
        }
        return true;
    }

    private List<NavigationNodeBean> getChildren(Node node, boolean firstActive, boolean showEmptyCategory) {
        ArrayList<NavigationNodeBean> nodes = new ArrayList<NavigationNodeBean>();
        boolean firstActiveSet = false;
        for (Node childNode : node) {
            NavigationNodeBean childNodeBean = new NavigationNodeBean(childNode);
            if (firstActive && !firstActiveSet) {
                childNodeBean.setActive(true);
                firstActiveSet = true;
            }
            if (!showEmptyCategory) {
                childNodeBean.setEmptyCategory(this.isEmptyCategory(childNode));
            }
            nodes.add(childNodeBean);
        }
        return nodes;
    }

    private boolean getShowEmptyCategory(PortletRequest request) {
        PortletPreferences portletPreferences = request.getPreferences();
        String showEmptyCategoryStringValue = portletPreferences.getValue(this.EMPTY_CATEGORY_PROPERTY_NAME, "false");
        return Boolean.valueOf(showEmptyCategoryStringValue);
    }
}

