/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import junitx.framework.ArrayAssert;
import org.apache.shindig.common.util.CharsetUtil;
import org.junit.Assert;
import org.junit.Test;

public class CharsetUtilTest {
    private static final byte[] LATIN1_UTF8_DATA = new byte[]{71, 97, 109, 101, 115, 44, 32, 72, 81, 44, 32, 77, 97, 110, 103, -61, -95, 44, 32, 65, 110, 105, 109, 101, 32, 101, 32, 116, 117, 100, 111, 32, 113, 117, 101, 32, 117, 109, 32, 98, 111, 109, 32, 110, 101, 114, 100, 32, 97, 109, 97};
    private static final String LATIN1_STRING = "Games, HQ, Mang\u00e1, Anime e tudo que um bom nerd ama";

    @Test
    public void testGetUtf8String() {
        ArrayAssert.assertEquals((byte[])new byte[]{105, 110}, (byte[])CharsetUtil.getUtf8Bytes((String)"in"));
        ArrayAssert.assertEquals((byte[])new byte[0], (byte[])CharsetUtil.getUtf8Bytes(null));
        this.testStringOfLength(0);
        this.testStringOfLength(10);
        this.testStringOfLength(100);
        this.testStringOfLength(1000);
    }

    private void testStringOfLength(int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append('a');
        }
        byte[] out = CharsetUtil.getUtf8Bytes((String)sb.toString());
        Assert.assertEquals((long)len, (long)out.length);
        for (int i = 0; i < len; ++i) {
            Assert.assertEquals((long)97L, (long)out[i]);
        }
    }

    @Test
    public void testLatin1() {
        ArrayAssert.assertEquals((byte[])LATIN1_UTF8_DATA, (byte[])CharsetUtil.getUtf8Bytes((String)LATIN1_STRING));
    }
}

