/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.uri;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class UriBuilderTest {
    @Test
    public void allPartsUsed() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").setQuery("hello=world").setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void noSchemeUsed() {
        UriBuilder builder = new UriBuilder().setAuthority("apache.org").setPath("/shindig").setQuery("hello=world").setFragment("foo");
        Assert.assertEquals((Object)"//apache.org/shindig?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void noAuthorityUsed() {
        UriBuilder builder = new UriBuilder().setScheme("http").setPath("/shindig").setQuery("hello=world").setFragment("foo");
        Assert.assertEquals((Object)"http:/shindig?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void noPathUsed() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setQuery("hello=world").setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void noQueryUsed() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig#foo", (Object)builder.toString());
    }

    @Test
    public void noFragmentUsed() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").setQuery("hello=world");
        Assert.assertEquals((Object)"http://apache.org/shindig?hello=world", (Object)builder.toString());
    }

    @Test
    public void hostRelativePaths() {
        UriBuilder builder = new UriBuilder().setPath("/shindig").setQuery("hello=world").setFragment("foo");
        Assert.assertEquals((Object)"/shindig?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void relativePaths() {
        UriBuilder builder = new UriBuilder().setPath("foo").setQuery("hello=world").setFragment("foo");
        Assert.assertEquals((Object)"foo?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void noPathNoHostNoAuthority() {
        UriBuilder builder = new UriBuilder().setQuery("hello=world").setFragment("foo");
        Assert.assertEquals((Object)"?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void justSchemeAndAuthority() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org");
        Assert.assertEquals((Object)"http://apache.org", (Object)builder.toString());
    }

    @Test
    public void justPath() {
        UriBuilder builder = new UriBuilder().setPath("/shindig");
        Assert.assertEquals((Object)"/shindig", (Object)builder.toString());
    }

    @Test
    public void justAuthorityAndPath() {
        UriBuilder builder = new UriBuilder().setAuthority("apache.org").setPath("/shindig");
        Assert.assertEquals((Object)"//apache.org/shindig", (Object)builder.toString());
    }

    @Test
    public void justQuery() {
        UriBuilder builder = new UriBuilder().setQuery("hello=world");
        Assert.assertEquals((Object)"?hello=world", (Object)builder.toString());
    }

    @Test
    public void justFragment() {
        UriBuilder builder = new UriBuilder().setFragment("foo");
        Assert.assertEquals((Object)"#foo", (Object)builder.toString());
    }

    @Test
    public void addSingleQueryParameter() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addQueryParameter("hello", "world").setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void addTwoQueryParameters() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addQueryParameter("hello", "world").addQueryParameter("foo", "bar").setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?hello=world&foo=bar#foo", (Object)builder.toString());
    }

    @Test
    public void iterableQueryParameters() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").putQueryParameter("hello", (Iterable)Lists.newArrayList((Object[])new String[]{"world", "monde"})).setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?hello=world&hello=monde#foo", (Object)builder.toString());
    }

    @Test
    public void removeQueryParameter() {
        UriBuilder uri = UriBuilder.parse((String)"http://www.example.com/foo?bar=baz&quux=baz");
        uri.removeQueryParameter("bar");
        Assert.assertEquals((Object)"http://www.example.com/foo?quux=baz", (Object)uri.toString());
        uri.removeQueryParameter("quux");
        Assert.assertEquals((Object)"http://www.example.com/foo", (Object)uri.toString());
    }

    @Test
    public void addIdenticalParameters() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addQueryParameter("hello", "world").addQueryParameter("hello", "goodbye").setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?hello=world&hello=goodbye#foo", (Object)builder.toString());
    }

    @Test
    public void addBatchParameters() {
        LinkedHashMap params = Maps.newLinkedHashMap();
        params.put("foo", "bar");
        params.put("hello", "world");
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addQueryParameters((Map)params).setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?foo=bar&hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void queryStringIsUnescaped() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").setQuery("hello+world=world%26bar");
        Assert.assertEquals((Object)"world&bar", (Object)builder.getQueryParameter("hello world"));
    }

    @Test
    public void queryParamsAreEscaped() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addQueryParameter("hello world", "foo&bar").setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?hello+world=foo%26bar#foo", (Object)builder.toString());
        Assert.assertEquals((Object)"hello+world=foo%26bar", (Object)builder.getQuery());
    }

    @Test
    public void addSingleFragmentParameter() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addFragmentParameter("hello", "world").setQuery("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?foo#hello=world", (Object)builder.toString());
    }

    @Test
    public void addTwoFragmentParameters() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addFragmentParameter("hello", "world").addFragmentParameter("foo", "bar").setQuery("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?foo#hello=world&foo=bar", (Object)builder.toString());
    }

    @Test
    public void iterableFragmentParameters() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").putFragmentParameter("hello", (Iterable)Lists.newArrayList((Object[])new String[]{"world", "monde"})).setQuery("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?foo#hello=world&hello=monde", (Object)builder.toString());
    }

    @Test
    public void removeFragmentParameter() {
        UriBuilder uri = UriBuilder.parse((String)"http://www.example.com/foo#bar=baz&quux=baz");
        uri.removeFragmentParameter("bar");
        Assert.assertEquals((Object)"http://www.example.com/foo#quux=baz", (Object)uri.toString());
        uri.removeFragmentParameter("quux");
        Assert.assertEquals((Object)"http://www.example.com/foo", (Object)uri.toString());
    }

    @Test
    public void addIdenticalFragmentParameters() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addFragmentParameter("hello", "world").addFragmentParameter("hello", "goodbye").setQuery("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?foo#hello=world&hello=goodbye", (Object)builder.toString());
    }

    @Test
    public void addBatchFragmentParameters() {
        LinkedHashMap params = Maps.newLinkedHashMap();
        params.put("foo", "bar");
        params.put("hello", "world");
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addFragmentParameters((Map)params).setQuery("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?foo#foo=bar&hello=world", (Object)builder.toString());
    }

    @Test
    public void fragmentStringIsUnescaped() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").setFragment("hello+world=world%26bar");
        Assert.assertEquals((Object)"world&bar", (Object)builder.getFragmentParameter("hello world"));
    }

    @Test
    public void fragmentParamsAreEscaped() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addFragmentParameter("hello world", "foo&bar").setQuery("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?foo#hello+world=foo%26bar", (Object)builder.toString());
        Assert.assertEquals((Object)"hello+world=foo%26bar", (Object)builder.getFragment());
    }

    @Test
    public void parse() {
        UriBuilder builder = UriBuilder.parse((String)"http://apache.org/shindig?foo=bar%26baz&foo=three#blah");
        Assert.assertEquals((Object)"http", (Object)builder.getScheme());
        Assert.assertEquals((Object)"apache.org", (Object)builder.getAuthority());
        Assert.assertEquals((Object)"/shindig", (Object)builder.getPath());
        Assert.assertEquals((Object)"foo=bar%26baz&foo=three", (Object)builder.getQuery());
        Assert.assertEquals((Object)"blah", (Object)builder.getFragment());
        Assert.assertEquals((Object)"bar&baz", (Object)builder.getQueryParameter("foo"));
        List<String> values = Arrays.asList("bar&baz", "three");
        Assert.assertEquals(values, (Object)builder.getQueryParameters("foo"));
    }

    @Test
    public void constructFromUriAndBack() {
        Uri uri = Uri.parse((String)"http://apache.org/foo/bar?foo=bar&a=b&c=d&y=z&foo=zoo#foo");
        UriBuilder builder = new UriBuilder(uri);
        Assert.assertEquals((Object)uri, (Object)builder.toUri());
    }

    @Test
    public void constructFromUriAndModify() {
        Uri uri = Uri.parse((String)"http://apache.org/foo/bar?foo=bar#foo");
        UriBuilder builder = new UriBuilder(uri);
        builder.setAuthority("example.org");
        builder.addQueryParameter("bar", "foo");
        Assert.assertEquals((Object)"http://example.org/foo/bar?foo=bar&bar=foo#foo", (Object)builder.toString());
    }

    @Test
    public void equalsAndHashCodeOk() {
        UriBuilder uri = UriBuilder.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        UriBuilder uri2 = new UriBuilder(Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo"));
        Assert.assertEquals((Object)uri, (Object)uri2);
        Assert.assertEquals((Object)uri2, (Object)uri);
        Assert.assertEquals((Object)uri, (Object)uri);
        Assert.assertNotNull((Object)uri);
        junitx.framework.Assert.assertNotEquals((Object)uri, (Object)"http://example.org/foo/bar/baz?blah=blah#boo");
        junitx.framework.Assert.assertNotEquals((Object)uri, (Object)Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo"));
        Assert.assertEquals((long)uri.hashCode(), (long)uri2.hashCode());
    }

    @Test
    public void constructFromServletRequestHttpStandardPortAndModify() {
        HttpServletRequest req = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getScheme()).andReturn((Object)"http").once();
        EasyMock.expect((Object)req.getServerName()).andReturn((Object)"example.com");
        EasyMock.expect((Object)req.getServerPort()).andReturn((Object)80).once();
        EasyMock.expect((Object)req.getRequestURI()).andReturn((Object)"/my/path");
        EasyMock.expect((Object)req.getQueryString()).andReturn((Object)"foo=bar&baz=bak");
        EasyMock.replay((Object[])new Object[]{req});
        UriBuilder builder = new UriBuilder(req);
        EasyMock.verify((Object[])new Object[]{req});
        Assert.assertEquals((Object)"http://example.com/my/path?foo=bar&baz=bak", (Object)builder.toString());
        Assert.assertEquals((Object)"bar", (Object)builder.getQueryParameter("foo"));
        Assert.assertEquals((long)0L, (long)builder.getFragmentParameters().size());
        builder.setPath("/other/path");
        Assert.assertEquals((Object)"http://example.com/other/path?foo=bar&baz=bak", (Object)builder.toString());
    }

    @Test
    public void constructFromServletRequestHttpsStandardPort() {
        HttpServletRequest req = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getScheme()).andReturn((Object)"https").once();
        EasyMock.expect((Object)req.getServerName()).andReturn((Object)"example.com");
        EasyMock.expect((Object)req.getServerPort()).andReturn((Object)443).once();
        EasyMock.expect((Object)req.getRequestURI()).andReturn((Object)"/my/path");
        EasyMock.expect((Object)req.getQueryString()).andReturn((Object)"foo=bar&baz=bak");
        EasyMock.replay((Object[])new Object[]{req});
        UriBuilder builder = new UriBuilder(req);
        EasyMock.verify((Object[])new Object[]{req});
        Assert.assertEquals((Object)"https://example.com/my/path?foo=bar&baz=bak", (Object)builder.toString());
    }

    @Test
    public void constructFromServletRequestNonStandardPort() {
        HttpServletRequest req = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getScheme()).andReturn((Object)"HtTp").once();
        EasyMock.expect((Object)req.getServerName()).andReturn((Object)"example.com");
        EasyMock.expect((Object)req.getServerPort()).andReturn((Object)5000).once();
        EasyMock.expect((Object)req.getRequestURI()).andReturn((Object)"/my/path");
        EasyMock.expect((Object)req.getQueryString()).andReturn((Object)"one=two&three=four");
        EasyMock.replay((Object[])new Object[]{req});
        UriBuilder builder = new UriBuilder(req);
        EasyMock.verify((Object[])new Object[]{req});
        Assert.assertEquals((Object)"http://example.com:5000/my/path?one=two&three=four", (Object)builder.toString());
    }

    @Test
    public void constructFromServletRequestNonePort() {
        HttpServletRequest req = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getScheme()).andReturn((Object)"http").once();
        EasyMock.expect((Object)req.getServerName()).andReturn((Object)"example.com");
        EasyMock.expect((Object)req.getServerPort()).andReturn((Object)-1).once();
        EasyMock.expect((Object)req.getRequestURI()).andReturn((Object)"/my/path");
        EasyMock.expect((Object)req.getQueryString()).andReturn((Object)"one=two&three=four");
        EasyMock.replay((Object[])new Object[]{req});
        UriBuilder builder = new UriBuilder(req);
        EasyMock.verify((Object[])new Object[]{req});
        Assert.assertEquals((Object)"http://example.com/my/path?one=two&three=four", (Object)builder.toString());
    }
}

