/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.expressions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.expressions.RootELResolver;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionsTest {
    public Expressions expressions;
    private ELContext context;
    private Map<String, Object> variables;

    @Before
    public void setUp() {
        this.expressions = Expressions.forTesting();
        this.variables = Maps.newHashMap();
        this.context = this.expressions.newELContext(new ELResolver[]{new RootELResolver(this.variables)});
    }

    @Test
    public void arraySupport() {
        this.addVariable("array", new String[]{"foo", "bar"});
        String result = this.evaluate("${array[0]}${array[1]}", String.class);
        Assert.assertEquals((Object)"foobar", (Object)result);
    }

    @Test
    public void listSupport() {
        this.addVariable("list", ImmutableList.of((Object)"foo", (Object)"bar"));
        String result = this.evaluate("${list[0]}${list[1]}", String.class);
        Assert.assertEquals((Object)"foobar", (Object)result);
    }

    @Test
    public void mapSupport() {
        this.addVariable("map", ImmutableMap.of((Object)"foo", (Object)"bar"));
        String result = this.evaluate("${map.foo}${map['foo']}", String.class);
        Assert.assertEquals((Object)"barbar", (Object)result);
    }

    @Test
    public void jsonObjectSupport() throws Exception {
        this.addVariable("object", new JSONObject("{foo: 125}"));
        int result = this.evaluate("${object.foo}", Integer.class);
        Assert.assertEquals((long)125L, (long)result);
    }

    @Test
    public void jsonArraySupport() throws Exception {
        this.addVariable("array", new JSONArray("[1, 2]"));
        int result = this.evaluate("${array[0] + array[1]}", Integer.class);
        Assert.assertEquals((long)3L, (long)result);
    }

    @Test
    public void jsonArrayCoercionOfStatic() throws Exception {
        JSONArray result = this.evaluate("first,second", JSONArray.class);
        JSONArray expected = new JSONArray("['first', 'second']");
        Assert.assertEquals((Object)expected.toString(), (Object)result.toString());
    }

    @Test
    public void jsonArrayCoercion() throws Exception {
        this.addVariable("foo", "first,second");
        JSONArray result = this.evaluate("${foo}", JSONArray.class);
        JSONArray expected = new JSONArray("['first', 'second']");
        Assert.assertEquals((Object)expected.toString(), (Object)result.toString());
    }

    @Test
    public void missingJsonSubproperty() throws Exception {
        this.addVariable("object", new JSONObject("{foo: 125}"));
        Assert.assertNull((Object)this.evaluate("${object.bar.baz}", Object.class));
    }

    @Test
    public void missingMapSubproperty() throws Exception {
        this.addVariable("map", ImmutableMap.of((Object)"key", (Object)"value"));
        Assert.assertNull((Object)this.evaluate("${map.bar.baz}", Object.class));
    }

    @Test(expected=PropertyNotFoundException.class)
    public void missingTopLevelVariable() throws Exception {
        Assert.assertNull((Object)this.evaluate("${map.bar.baz}", Object.class));
    }

    @Test
    public void booleanCoercionOfBooleans() throws Exception {
        this.addVariable("bool", false);
        Assert.assertFalse((boolean)this.evaluate("${bool}", Boolean.class));
        Assert.assertTrue((boolean)this.evaluate("${!bool}", Boolean.class));
        this.addVariable("bool", true);
        Assert.assertTrue((boolean)this.evaluate("${bool}", Boolean.class));
        Assert.assertFalse((boolean)this.evaluate("${!bool}", Boolean.class));
    }

    @Test
    public void booleanCoercionOfNumbers() throws Exception {
        this.addVariable("bool", 0);
        Assert.assertFalse((boolean)this.evaluate("${bool}", Boolean.class));
        this.addVariable("bool", 1);
        Assert.assertTrue((boolean)this.evaluate("${bool}", Boolean.class));
    }

    @Test
    public void booleanCoercionOfNull() throws Exception {
        this.addVariable("bool", null);
        Assert.assertFalse((boolean)this.evaluate("${bool}", Boolean.class));
        Assert.assertTrue((boolean)this.evaluate("${!bool}", Boolean.class));
    }

    @Test
    public void booleanCoercionOfStrings() throws Exception {
        this.addVariable("bool", "");
        Assert.assertFalse((boolean)this.evaluate("${bool}", Boolean.class));
        Assert.assertTrue((boolean)this.evaluate("${!bool}", Boolean.class));
        this.addVariable("bool", "false");
        Assert.assertFalse((boolean)this.evaluate("${bool}", Boolean.class));
        Assert.assertTrue((boolean)this.evaluate("${!bool}", Boolean.class));
        this.addVariable("bool", "FALSE");
        Assert.assertTrue((boolean)this.evaluate("${bool}", Boolean.class));
        this.addVariable("bool", "true");
        Assert.assertTrue((boolean)this.evaluate("${bool}", Boolean.class));
        Assert.assertFalse((boolean)this.evaluate("${!bool}", Boolean.class));
        this.addVariable("bool", "booga");
        Assert.assertTrue((boolean)this.evaluate("${bool}", Boolean.class));
    }

    @Test
    public void iterableCoercionOfScalar() throws Exception {
        this.addVariable("iter", "foo");
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo"), (Object)this.evaluate("${iter}", Iterable.class));
    }

    @Test
    public void iterableCoercionOfNull() throws Exception {
        this.addVariable("iter", null);
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.evaluate("${iter}", Iterable.class));
    }

    @Test
    public void iterableCoercionOfCollection() throws Exception {
        this.addVariable("iter", ImmutableList.of((Object)1, (Object)2, (Object)3));
        Assert.assertEquals((Object)ImmutableList.of((Object)1, (Object)2, (Object)3), (Object)this.evaluate("${iter}", Iterable.class));
    }

    @Test
    public void iterableCoercionOfJSONArray() throws Exception {
        this.addVariable("iter", new JSONArray("[1,2,3]"));
        Assert.assertEquals((Object)ImmutableList.of((Object)1, (Object)2, (Object)3), (Object)ImmutableList.copyOf((Iterable)this.evaluate("${iter}", Iterable.class)));
    }

    @Test
    public void iterableCoercionOfJSONObjectWithListProperty() throws Exception {
        this.addVariable("iter", new JSONObject("{list: [1,2,3]}"));
        Assert.assertEquals((Object)ImmutableList.of((Object)1, (Object)2, (Object)3), (Object)ImmutableList.copyOf((Iterable)this.evaluate("${iter}", Iterable.class)));
    }

    @Test
    public void iterableCoercionOfJSONObjectWithoutListProperty() throws Exception {
        JSONObject json = new JSONObject("{foo: [1,2,3]}");
        this.addVariable("iter", json);
        Assert.assertEquals((Object)ImmutableList.of((Object)json), (Object)ImmutableList.copyOf((Iterable)this.evaluate("${iter}", Iterable.class)));
    }

    public <T> T evaluate(String expression, Class<T> type) {
        ValueExpression expr = this.expressions.parse(expression, type);
        return type.cast(expr.getValue(this.context));
    }

    public void addVariable(String key, Object value) {
        this.variables.put(key, value);
    }
}

