/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.opensso.plugin;

import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gatein.sso.opensso.plugin.GateInPrincipal;
import org.gatein.sso.plugin.RestCallbackCaller;

public class AuthenticationPlugin
extends AMLoginModule {
    private static final Log log = LogFactory.getLog(AuthenticationPlugin.class);
    private RestCallbackCaller restCallbackCaller;
    private String username;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Subject subject, Map sharedState, Map options) {
        InputStream is = null;
        try {
            Properties properties = new Properties();
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("gatein.properties");
            properties.load(is);
            String gateInHost = properties.getProperty("host");
            String gateInPort = properties.getProperty("port");
            String gateInContext = properties.getProperty("context");
            String gateInProtocol = properties.getProperty("protocol");
            String gateInHttpMethod = properties.getProperty("httpMethod");
            log.debug((Object)("GateIn Host: " + gateInHost + ", GateIn Port: " + gateInPort + ", GateIn context: " + gateInContext + ", Protocol=" + gateInProtocol + ", http method=" + gateInHttpMethod));
            this.restCallbackCaller = new RestCallbackCaller(gateInProtocol, gateInHost, gateInPort, gateInContext, gateInHttpMethod);
        }
        catch (IOException ioe) {
            log.error((Object)"Error during initialization of login module", (Throwable)ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        try {
            String password = null;
            for (int i = 0; i < callbacks.length; ++i) {
                Callback callback = callbacks[i];
                if (callback instanceof NameCallback) {
                    this.username = ((NameCallback)callback).getName();
                    continue;
                }
                if (!(callback instanceof PasswordCallback)) continue;
                password = new String(((PasswordCallback)callback).getPassword());
            }
            boolean success = this.restCallbackCaller.executeRemoteCall(this.username, password);
            if (!success) {
                throw new AuthLoginException("GateIn Login Callback Failed!!");
            }
            return -1;
        }
        catch (Throwable e) {
            throw new AuthLoginException(e);
        }
    }

    public Principal getPrincipal() {
        return new GateInPrincipal(this.username);
    }
}

